<?php
namespace Crocoblock_Wizard\Modules\Welcome;

use Crocoblock_Wizard\Base\Module as Module_Base;
use Crocoblock_Wizard\Plugin as Plugin;

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

class Module extends Module_Base {

	/**
	 * Returns module slug
	 *
	 * @return void
	 */
	public function get_slug() {
		return 'welcome';
	}

	/**
	 * Enqueue module-specific assets
	 *
	 * @return void
	 */
	public function enqueue_module_assets() {

		wp_enqueue_script(
			'crocoblock-wizard-welcome',
			CB_WIZARD_URL . 'assets/js/welcome.js',
			array( 'cx-vue-ui' ),
			CB_WIZARD_VERSION,
			true
		);

	}

	/**
	 * License page config
	 *
	 * @param  array  $config  [description]
	 * @param  string $subpage [description]
	 * @return [type]          [description]
	 */
	public function page_config( $config = array(), $subpage = '' ) {

		$config['body']        = 'cbw-welcome';
		$config['wrapper_css'] = 'welcome-page';
		$config['has_header']  = false;
		$config['actions']     = $this->get_allowed_actions();

		return $config;

	}

	/**
	 * Returns allowed actions list
	 *
	 * @return [type] [description]
	 */
	public function get_allowed_actions() {
		return apply_filters( 'crocoblock-wizard/welcome/actions', array(
			array(
				'icon'         => '<svg width="70" height="80" viewBox="0 0 70 80" fill="none" xmlns="http://www.w3.org/2000/svg"><path opacity="0.3" d="M13 22C13 22.4 8.33333 22.1667 6 22V3L9 1H22L31 8H61L64 10V22H57V17L55 14H15L13 16V22Z" fill="white"/><path d="M64.9996 21.1V11.9C64.9996 9.29999 62.8996 7.19999 60.3996 7.19999H32.2996C31.0996 7.19999 29.8996 6.69999 28.9996 5.79999L24.7996 1.49999C23.8996 0.599987 22.7996 0.0999869 21.4996 0.0999869H9.59956C7.09956 -1.30683e-05 4.99955 2.09999 4.99955 4.69999V21C2.59955 21.3 0.799555 23.5 0.999555 26.1L3.59955 55.6C3.79955 58.1 5.79955 60 8.19955 60H33.9996V76.6L30.6996 73.3C30.2996 72.9 29.6996 72.9 29.2996 73.3C28.8996 73.7 28.8996 74.3 29.2996 74.7L34.2996 79.7C34.4996 79.9 34.7996 80 34.9996 80C35.2996 80 35.4996 79.9 35.6996 79.7L40.6996 74.7C41.0996 74.3 41.0996 73.7 40.6996 73.3C40.2996 72.9 39.6996 72.9 39.2996 73.3L35.9996 76.6V60H61.7996C64.1996 60 66.1996 58.1 66.3996 55.7L68.9996 26.2C69.1996 23.6 67.3996 21.4 64.9996 21.1ZM9.59956 1.99999H21.4996C22.1996 1.99999 22.7996 2.29999 23.2996 2.79999L27.4996 7.09999C28.6996 8.39999 30.3996 9.09999 32.1996 9.09999H60.2996C61.6996 9.09999 62.8996 10.3 62.8996 11.8V21H57.8996V17C57.8996 14.8 56.0996 13 53.8996 13H15.9996C13.7996 13 11.9996 14.8 11.9996 17V21H6.99955V4.69999C6.99955 3.19999 8.19955 1.99999 9.59956 1.99999ZM55.9996 21H13.9996V17C13.9996 15.9 14.8996 15 15.9996 15H53.9996C55.0996 15 55.9996 15.9 55.9996 17V21ZM64.3996 55.5C64.2996 56.9 63.1996 58 61.7996 58H35.9996V52C35.9996 51.4 35.5996 51 34.9996 51C34.3996 51 33.9996 51.4 33.9996 52V58H8.19955C6.89955 58 5.69955 56.9 5.59955 55.5L2.99955 26C2.89955 25.2 3.19955 24.4 3.69955 23.9C4.19955 23.3 4.89955 23 5.59955 23H64.3996C65.0996 23 65.7996 23.3 66.2996 23.8C66.7996 24.4 67.0996 25.2 66.9996 25.9L64.3996 55.5Z" fill="white"/><path d="M20.4 37.2C21 37.2 21.5 36.7 21.5 36.1C21.5 35.5 21 35 20.4 35C18 35 16 37 16 39.5C16 42 18 44 20.4 44C21 44 21.5 43.5 21.5 42.9C21.5 42.3 21 41.8 20.4 41.8C19.2 41.8 18.2 40.8 18.2 39.6C18.2 38.2 19.2 37.2 20.4 37.2Z" fill="white"/><path d="M42.4 37.3C43 37.3 43.5 36.8 43.5 36.2C43.5 35.6 43 35.1 42.4 35.1C39.9 35.1 38 37.1 38 39.6C38 42.1 40 44.1 42.4 44.1C43 44.1 43.5 43.6 43.5 43C43.5 42.4 43 41.9 42.4 41.9C41.2 41.9 40.2 40.9 40.2 39.7C40.1 38.3 41.1 37.3 42.4 37.3Z" fill="white"/><path d="M26.5992 35C24.0992 35 22.1992 37 22.1992 39.5V42.9C22.1992 43.5 22.6992 44 23.2992 44C23.8992 44 24.3992 43.5 24.3992 42.9V39.5C24.3992 38.3 25.3992 37.3 26.5992 37.3C27.1992 37.3 27.6992 36.8 27.6992 36.2C27.6992 35.5 27.1992 35 26.5992 35Z" fill="white"/><path d="M32.7984 35C30.2984 35 28.3984 37 28.3984 39.5C28.3984 42 30.3984 43.9 32.7984 44C33.3984 44 33.8984 43.5 33.8984 42.9C33.8984 42.3 33.3984 41.8 32.7984 41.8C31.5984 41.8 30.5984 40.8 30.5984 39.6C30.5984 38.4 31.5984 37.4 32.7984 37.4C33.9984 37.4 34.9984 38.4 34.9984 39.6C34.9984 40.1 34.7984 40.6 34.5984 40.9C34.3984 41.1 34.2984 41.4 34.2984 41.7C34.2984 42.3 34.7984 42.8 35.3984 42.8C35.6984 42.8 36.0984 42.6 36.2984 42.4C36.8984 41.6 37.2984 40.7 37.2984 39.6C37.2984 37 35.2984 35 32.7984 35Z" fill="white"/><path d="M48.5992 35.1C46.0992 35.1 44.1992 37.1 44.1992 39.6C44.1992 42.1 46.1992 44 48.5992 44.1C49.1992 44.1 49.6992 43.6 49.6992 43C49.6992 42.4 49.1992 41.9 48.5992 41.9C47.3992 41.9 46.3992 40.9 46.3992 39.7C46.3992 38.5 47.3992 37.5 48.5992 37.5C49.7992 37.5 50.7992 38.5 50.7992 39.7C50.7992 40.2 50.5992 40.7 50.3992 41C50.1992 41.2 50.0992 41.5 50.0992 41.8C50.0992 42.4 50.5992 42.9 51.1992 42.9C51.4992 42.9 51.8992 42.7 52.0992 42.5C52.6992 41.7 53.0992 40.8 53.0992 39.7C52.9992 37.1 50.9992 35.1 48.5992 35.1Z" fill="white"/></svg>',
				'title'        => __( 'Install Crocoblock', 'crocoblock-wizard' ),
				'action_label' => __( 'Let\'s Go', 'crocoblock-wizard' ),
				'action_url'   => Plugin::instance()->dashboard->page_url( 'license' ),
				'desc'         => __( 'Choose this option to install Crocoblock products. This step allows to install one of the skins provided by Crocoblock, as well as the plugins needed for it to work.', 'crocoblock-wizard' ),
				'featured'     => 1,
			),
			array(
				'icon'         => '<svg width="60" height="60" viewBox="0 0 60 60" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M1 4C1 2.34315 2.34315 1 4 1H42C43.6569 1 45 2.34315 45 4V14H1V4Z" fill="white" fill-opacity="0.3" stroke="white" stroke-width="2"/><circle cx="7.5" cy="7.5" r="1.5" fill="white"/><circle cx="12.5" cy="7.5" r="1.5" fill="white"/><circle cx="17.5" cy="7.5" r="1.5" fill="white"/><path d="M1 14H45V56C45 57.6569 43.6569 59 42 59H4C2.34314 59 1 57.6569 1 56V14Z" stroke="white" stroke-width="2"/><path d="M27 45C26.4477 45 26 44.5523 26 44C26 43.4477 26.4477 43 27 43L59 43C59.5523 43 60 43.4477 60 44C60 44.5523 59.5523 45 59 45L27 45Z" fill="white"/><path d="M54.7195 49.705C54.3261 50.0983 53.6884 50.0983 53.295 49.705C52.9017 49.3116 52.9017 48.6739 53.295 48.2805L58.2805 43.295C58.6739 42.9017 59.3116 42.9017 59.705 43.295C60.0983 43.6884 60.0983 44.3261 59.705 44.7195L54.7195 49.705Z" fill="white"/><path d="M54.7195 38.295C54.3261 37.9017 53.6884 37.9017 53.295 38.295C52.9017 38.6884 52.9017 39.3261 53.295 39.7195L58.2805 44.705C58.6739 45.0983 59.3116 45.0983 59.705 44.705C60.0983 44.3116 60.0983 43.6739 59.705 43.2805L54.7195 38.295Z" fill="white"/><rect x="6" y="19" width="15" height="2" rx="1" fill="white"/><rect x="6" y="23" width="8" height="2" rx="1" fill="white"/></svg>',
				'title'        => __( 'Export skin', 'crocoblock-wizard' ),
				'action_label' => __( 'Click here', 'crocoblock-wizard' ),
				'action_url'   => Plugin::instance()->dashboard->page_url( 'export-skin' ),
				'desc'         => __( 'Choose this option in case you’ve built your own skin with all the content and structure preserved. The Wizard will help you export it to another site.', 'crocoblock-wizard' ),
				'featured' => 0,
			),
			array(
				'icon'         => '<svg width="60" height="60" viewBox="0 0 60 60" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M1 4C1 2.34315 2.34315 1 4 1H42C43.6569 1 45 2.34315 45 4V14H1V4Z" fill="white" fill-opacity="0.3" stroke="white" stroke-width="2"/><circle cx="7.5" cy="7.5" r="1.5" fill="white"/><circle cx="12.5" cy="7.5" r="1.5" fill="white"/><circle cx="17.5" cy="7.5" r="1.5" fill="white"/><path d="M1 14H45V56C45 57.6569 43.6569 59 42 59H4C2.34314 59 1 57.6569 1 56V14Z" stroke="white" stroke-width="2"/><path d="M59 45C59.5523 45 60 44.5523 60 44C60 43.4477 59.5523 43 59 43L27 43C26.4477 43 26 43.4477 26 44C26 44.5523 26.4477 45 27 45L59 45Z" fill="white"/><path d="M31.2805 49.705C31.6739 50.0983 32.3116 50.0983 32.705 49.705C33.0983 49.3116 33.0983 48.6739 32.705 48.2805L27.7195 43.295C27.3261 42.9017 26.6884 42.9017 26.295 43.295C25.9017 43.6884 25.9017 44.3261 26.295 44.7195L31.2805 49.705Z" fill="white"/><path d="M31.2805 38.295C31.6739 37.9017 32.3116 37.9017 32.705 38.295C33.0983 38.6884 33.0983 39.3261 32.705 39.7195L27.7195 44.705C27.3261 45.0983 26.6884 45.0983 26.295 44.705C25.9017 44.3116 25.9017 43.6739 26.295 43.2805L31.2805 38.295Z" fill="white"/><rect x="6" y="19" width="15" height="2" rx="1" fill="white"/><rect x="6" y="23" width="8" height="2" rx="1" fill="white"/></svg>',
				'title'        => __( 'Import skin', 'crocoblock-wizard' ),
				'action_label' => __( 'Click here', 'crocoblock-wizard' ),
				'action_url'   => Plugin::instance()->dashboard->page_url(
					'select-skin',
					array(
						'action' => 'import',
					)
				),
				'desc'         => __( 'Choose this option to import the skin that’s been previously exported using Crocoblock Wizard. All the data that was included in it will be applied to this site. ', 'crocoblock-wizard' ),
				'featured'     => 0,
			),
			array(
				'icon'         => '<svg width="60" height="60" viewBox="0 0 60 60" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M6.00024 22C6.00024 21.4477 6.44796 21 7.00024 21H21.0002C21.5525 21 22.0002 21.4477 22.0002 22C22.0002 22.5523 21.5525 23 21.0002 23H7.00024C6.44796 23 6.00024 22.5523 6.00024 22Z" fill="white"/><path d="M6.00024 26C6.00024 25.4477 6.44796 25 7.00024 25H13.0002C13.5525 25 14.0002 25.4477 14.0002 26C14.0002 26.5523 13.5525 27 13.0002 27H7.00024C6.44796 27 6.00024 26.5523 6.00024 26Z" fill="white"/><path d="M42.0001 47H55.0001C57.2092 47 59.0001 45.2091 59.0001 43V15H1V43C1 45.2091 2.79086 47 5 47H21.5001" stroke="white" stroke-width="2"/><path d="M36.0001 44.2471V32.2471C36.0001 30.6471 34.6668 30.2471 34.0001 30.2471C33.2002 30.2471 32.6667 31.247 32.5 31.7471V36.2471C32.3333 36.0804 31.7 35.7471 30.5 35.7471C29.3 35.7471 28.6667 37.0804 28.5 37.7471C28.5 37.5804 28.2 37.2471 27 37.2471C25.8 37.2471 25.1667 38.5804 25 39.2471H22.5001C21.8334 41.5804 20.8001 46.9471 22.0001 49.7471C23.5001 53.2471 25.5001 54.7471 29.0001 54.7471C31.8001 54.7471 33.8334 54.4137 34.5001 54.2471L41.5001 47.2471C42.5001 46.2471 43.5001 44.2471 43.5001 43.7471C43.5001 43.2471 42.5001 42.2471 40.5001 42.2471C38.9001 42.2471 36.8334 43.5804 36.0001 44.2471Z" fill="white" fill-opacity="0.3"/><path fill-rule="evenodd" clip-rule="evenodd" d="M28.0635 32.1277C28.0635 28.748 30.8344 26 34.2421 26C37.6499 26 40.4208 28.748 40.4208 32.1277C40.4208 32.6117 40.0238 33.0055 39.5358 33.0055C39.0478 33.0055 38.6507 32.6117 38.6507 32.1277C38.6507 29.716 36.6739 27.7555 34.2421 27.7555C31.8104 27.7555 29.8335 29.716 29.8335 32.1277C29.8335 32.6117 29.4365 33.0055 28.9485 33.0055C28.4605 33.0055 28.0635 32.6117 28.0635 32.1277ZM43.7792 42.6853C42.5054 41.0036 40.1315 40.6017 38.3615 41.7665L36.8892 42.7345V32.1196C36.8892 30.6759 35.6981 29.4946 34.2423 29.4946C32.7866 29.4946 31.5955 30.6759 31.5955 32.1196V34.8923C31.3226 34.7938 31.0248 34.7446 30.7105 34.7446C29.4946 34.7446 28.4607 35.5649 28.1547 36.6806C27.8486 36.5657 27.5261 36.5001 27.1787 36.5001C25.9628 36.5001 24.9289 37.3204 24.6228 38.436C24.3168 38.3212 23.9942 38.2556 23.6468 38.2556C22.1911 38.2556 21 39.4368 21 40.8806V47.8778C21 50.3447 22.1521 52.5519 23.9503 53.9973H23.655C23.167 53.9973 22.77 54.3911 22.77 54.875V58.3778C22.77 58.8618 23.167 59.2555 23.655 59.2555C24.1431 59.2555 24.5401 58.8536 24.5401 58.3696V55.7446H28.5749C28.6961 55.7501 28.8179 55.7528 28.9404 55.7528H31.9016C32.0086 55.7528 32.1153 55.7501 32.2216 55.7446H35.1273V58.3696C35.1273 58.8536 35.5244 59.2473 36.0124 59.2473C36.5004 59.2473 36.8974 58.8536 36.8974 58.3696V54.8668C36.8903 54.4578 36.6019 54.1093 36.211 54.0197C36.2958 53.9383 36.3786 53.8542 36.4591 53.7677L43.5972 46.0403C44.4739 45.1052 44.5401 43.6942 43.7792 42.6853ZM28.931 53.9973H31.9398C33.1644 53.9913 34.3382 53.4753 35.1687 52.5782L42.3069 44.8509C42.5964 44.5392 42.6212 44.0716 42.3978 43.7353C41.6865 42.7919 40.3548 42.5704 39.3706 43.2185L36.5335 45.097C36.2688 45.2692 35.9214 45.2938 35.6319 45.138C35.3424 44.9821 35.1605 44.6868 35.1605 44.3669V32.1196C35.1605 31.6356 34.7634 31.2419 34.2754 31.2419C33.7874 31.2419 33.3904 31.6356 33.3904 32.1196V41.7501C33.3904 42.2341 32.9934 42.6278 32.5054 42.6278C32.0174 42.6278 31.6203 42.2341 31.6203 41.7501V37.3778C31.6203 36.8938 31.2233 36.5001 30.7353 36.5001C30.2473 36.5001 29.8503 36.8938 29.8503 37.3778V41.7501C29.8503 42.2341 29.4533 42.6278 28.9653 42.6278C28.4773 42.6278 28.0802 42.2341 28.0802 41.7501V39.1251C28.0802 38.6411 27.6832 38.2474 27.1952 38.2474C26.7072 38.2474 26.3102 38.6411 26.3102 39.1251V41.7501C26.3102 42.2341 25.9132 42.6278 25.4251 42.6278C24.9371 42.6278 24.5401 42.2341 24.5401 41.7501V40.8724C24.5401 40.3884 24.1514 39.9946 23.6634 39.9946C23.1754 39.9946 22.7783 40.3884 22.7783 40.8724V47.8696C22.7783 51.2407 25.5351 53.9834 28.931 53.9973Z" fill="white"/><path d="M49 20L54 25" stroke="white" stroke-width="2" stroke-linecap="round"/><path d="M54 20L49 25" stroke="white" stroke-width="2" stroke-linecap="round"/><path d="M1 5C1 3.34315 2.34315 2 4 2H56C57.6569 2 59 3.34315 59 5V15H1V5Z" fill="white" fill-opacity="0.3" stroke="white" stroke-width="2"/><circle cx="7.5" cy="8.5" r="1.5" fill="white"/><circle cx="12.5" cy="8.5" r="1.5" fill="white"/><circle cx="17.5" cy="8.5" r="1.5" fill="white"/></svg>',
				'title'        => __( 'Interactive Popup Library', 'crocoblock-wizard' ),
				'action_label' => __( 'Click here', 'crocoblock-wizard' ),
				'action_url'   => Plugin::instance()->dashboard->page_url( 'popups-license' ),
				'desc'         => __( 'Choose this option to install Crocoblock’s Interactive Popup Library. The Wizard will help you quickly import any themed template.', 'crocoblock-wizard' ),
				'featured'     => 0,
			),
		) );
	}

	/**
	 * Add welcome component template
	 *
	 * @param  array  $templates [description]
	 * @param  string $subpage   [description]
	 * @return [type]            [description]
	 */
	public function page_templates( $templates = array(), $subpage = '' ) {

		$templates['welcome'] = 'welcome/main';
		return $templates;

	}

}
