# Configuración de Google Maps API

Para que el mapa funcione correctamente, necesitas configurar Google Maps API:

## 1. Obtener una clave de API de Google Maps

1. Ve a [Google Cloud Console](https://console.cloud.google.com/)
2. Crea un nuevo proyecto o selecciona uno existente
3. Habilita las siguientes APIs:
   - **Maps JavaScript API**
   - **Places API**
   - **Geocoding API**

## 2. Crear clave de API

1. Ve a "Credenciales" en el menú lateral
2. Haz clic en "Crear credenciales" > "Clave de API"
3. Copia la clave generada

## 3. Configurar restricciones (Recomendado)

### Restricciones de aplicación:
- Tipo: **Restricciones de referente HTTP**
- Referentes del sitio web:
  - `tu-dominio.com/*`
  - `www.tu-dominio.com/*`
  - `localhost/*` (para desarrollo)

### Restricciones de API:
Selecciona solo las APIs necesarias:
- Maps JavaScript API
- Places API
- Geocoding API

## 4. Configurar en el plugin

Edita el archivo `includes/class-hpcp-form.php` en la línea que dice:

```php
wp_register_script( 'google-maps', 'https://maps.googleapis.com/maps/api/js?key=YOUR_API_KEY&libraries=places&callback=initMap', [], null, true );
```

Reemplaza `YOUR_API_KEY` con tu clave real:

```php
wp_register_script( 'google-maps', 'https://maps.googleapis.com/maps/api/js?key=AIzaSyC123456789abcdefghijklmnop&libraries=places&callback=initMap', [], null, true );
```

## 5. Características del mapa

- **Autocompletado**: Busca direcciones en tiempo real
- **Arrastrar marcador**: Actualiza automáticamente los campos
- **Clic en mapa**: Coloca el marcador y obtiene la dirección
- **Restricción geográfica**: Solo México
- **Autocompletado de campos**:
  - Estado
  - Ciudad
  - Colonia
  - Código Postal
  - Coordenadas (Latitud/Longitud)
  - Dirección completa

## 6. Facturación

Google Maps requiere una cuenta de facturación, pero ofrece:
- $200 USD de crédito mensual gratuito
- Hasta 28,000 cargas de mapa gratuitas por mes
- Suficiente para sitios web pequeños a medianos

## Solución alternativa sin API Key

Si prefieres no usar Google Maps API, puedes:

1. Comentar la línea de Google Maps en `enqueue_assets()`
2. Los campos de ubicación funcionarán como inputs manuales
3. El usuario deberá completar manualmente estado, ciudad, etc.