# Shortcode: [hp_desplegado_mapa]

Este shortcode muestra un mapa interactivo con la ubicación de la propiedad actual. Está diseñado para usarse en el template single de propiedades.

## Uso básico

```
[hp_desplegado_mapa]
```

## Parámetros disponibles

| Parámetro | Valor por defecto | Descripción |
|-----------|-------------------|-------------|
| `height` | `400px` | Altura del mapa |
| `width` | `100%` | Ancho del mapa |
| `zoom` | `15` | Nivel de zoom (1-20) |
| `show_info` | `true` | Mostrar panel de información |

## Ejemplos de uso

### Mapa básico
```
[hp_desplegado_mapa]
```

### Mapa personalizado
```
[hp_desplegado_mapa height="300px" zoom="16" show_info="false"]
```

### Mapa grande con zoom alejado
```
[hp_desplegado_mapa height="500px" zoom="12" width="100%"]
```

## Funcionalidades

### 🗺️ Mapa interactivo
- Zoom, arrastrar, Street View, pantalla completa
- Marcador personalizado con colores del tema
- InfoWindow con información de la propiedad

### 📍 Información de ubicación
- Dirección completa
- Colonia, ciudad, estado
- Coordenadas exactas
- Panel informativo opcional

### 🔧 Requerimientos
- **API Key de Google Maps** configurada en el panel de administración
- **Post type** `properties`
- **Metadatos** de ubicación: `latitud`, `longitud`

### ⚠️ Validaciones automáticas
- Verifica que hay API Key configurada
- Confirma que es un post de tipo `properties`
- Valida que existen coordenadas de ubicación

## Datos que utiliza

El shortcode obtiene automáticamente los siguientes metadatos del post actual:

- `latitud` - Coordenada de latitud
- `longitud` - Coordenada de longitud  
- `_address` - Dirección específica
- `estados` - Estado/provincia
- `ciudad` - Ciudad
- `colonia` - Colonia/barrio
- `post_title` - Título de la propiedad

## Implementación en templates

### En single-properties.php
```php
<?php if (function_exists('do_shortcode')): ?>
    <div class="property-location-section">
        <h3>Ubicación de la propiedad</h3>
        <?php echo do_shortcode('[hp_desplegado_mapa height="400px" zoom="15"]'); ?>
    </div>
<?php endif; ?>
```

### Con Gutenberg
Simplemente agrega un bloque de shortcode y escribe:
```
[hp_desplegado_mapa]
```

### Con constructores de páginas
La mayoría de constructores tienen widgets de shortcode donde puedes pegar:
```
[hp_desplegado_mapa height="350px" zoom="16"]
```

## Personalización CSS

El shortcode genera estas clases CSS que puedes personalizar:

```css
.hpcp-display-map-container { /* Contenedor principal */ }
.hpcp-location-info { /* Panel de información */ }
.hpcp-location-title { /* Título "Ubicación de la propiedad" */ }
.hpcp-location-details { /* Contenido del panel */ }
.hpcp-display-map { /* Contenedor del mapa */ }
.hpcp-map-notice { /* Mensajes de error/info */ }
```

## Mensajes de error

### "Google Maps no está configurado"
- Ve a **Configuración → Crear Propiedad**
- Agrega tu API Key de Google Maps

### "Este mapa solo funciona en propiedades"
- El shortcode debe usarse solo en posts de tipo `properties`

### "No hay información de ubicación para esta propiedad"
- La propiedad no tiene coordenadas `latitud` y `longitud`
- Verifica que se guardó correctamente desde el formulario

## Compatibilidad

- ✅ WordPress 5.6+
- ✅ PHP 7.4+
- ✅ Google Maps JavaScript API v3
- ✅ Responsive design
- ✅ Accesibilidad web

## Rendimiento

- Los scripts solo se cargan cuando se usa el shortcode
- Carga asíncrona de Google Maps API
- Optimizado para SEO y velocidad