(function($){
  'use strict';

  // Variables para el mapa de visualización
  var displayMap = null;
  var displayMarker = null;
  var displayMapInitialized = false;

  // Callback para inicializar el mapa de visualización
  window.initDisplayMap = function() {
    if (displayMapInitialized || typeof hpcpMapData === 'undefined') {
      return;
    }

    var mapContainer = document.querySelector('.hpcp-display-map');
    if (!mapContainer) {
      return;
    }

    displayMapInitialized = true;

    // Coordenadas de la propiedad
    var propertyLocation = {
      lat: parseFloat(hpcpMapData.lat),
      lng: parseFloat(hpcpMapData.lng)
    };

    var zoom = parseInt(mapContainer.getAttribute('data-zoom')) || 15;

    // Crear el mapa
    displayMap = new google.maps.Map(mapContainer, {
      zoom: zoom,
      center: propertyLocation,
      mapTypeControl: true,
      streetViewControl: true,
      fullscreenControl: true,
      zoomControl: true,
      styles: [
        {
          "featureType": "poi.business",
          "stylers": [{"visibility": "on"}]
        }
      ]
    });

    // Crear marcador
    displayMarker = new google.maps.Marker({
      position: propertyLocation,
      map: displayMap,
      title: hpcpMapData.title || 'Propiedad',
      icon: {
        url: 'data:image/svg+xml;charset=UTF-8,' + encodeURIComponent(
          '<svg width="32" height="32" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg">' +
          '<circle cx="16" cy="16" r="12" fill="#16182D" stroke="#fff" stroke-width="3"/>' +
          '<circle cx="16" cy="16" r="6" fill="#fff"/>' +
          '</svg>'
        ),
        scaledSize: new google.maps.Size(32, 32),
        anchor: new google.maps.Point(16, 16)
      }
    });

    // Crear contenido del InfoWindow
    var infoContent = '<div class="hpcp-info-window" style="color: #333 !important; font-family: system-ui, -apple-system, Segoe UI, Roboto, Arial, sans-serif;">';
    infoContent += '<h4 style="margin: 0 0 8px 0 !important; color: #16182D !important; font-weight: bold !important; font-size: 16px;">' + (hpcpMapData.title || 'Propiedad') + '</h4>';
    
    if (hpcpMapData.direccion) {
      infoContent += '<p style="margin: 4px 0 !important; color: #333 !important; line-height: 1.4;"><strong style="color: #16182D !important;">📍 Dirección:</strong><br>' + hpcpMapData.direccion + '</p>';
    }
    
    if (hpcpMapData.colonia) {
      infoContent += '<p style="margin: 4px 0 !important; color: #333 !important; line-height: 1.4;"><strong style="color: #16182D !important;">🏘️ Colonia:</strong> ' + hpcpMapData.colonia + '</p>';
    }
    
    if (hpcpMapData.ciudad || hpcpMapData.estado) {
      var location = [hpcpMapData.ciudad, hpcpMapData.estado].filter(Boolean).join(', ');
      infoContent += '<p style="margin: 4px 0 !important; color: #333 !important; line-height: 1.4;"><strong style="color: #16182D !important;">🏙️ Ubicación:</strong> ' + location + '</p>';
    }
    
    infoContent += '<p style="margin: 4px 0 !important; font-size: 12px; color: #666 !important; line-height: 1.4;"><strong style="color: #16182D !important;">📍 Coordenadas:</strong> ' + hpcpMapData.lat + ', ' + hpcpMapData.lng + '</p>';
    infoContent += '</div>';

    // Crear InfoWindow
    var infoWindow = new google.maps.InfoWindow({
      content: infoContent
    });

    // Mostrar InfoWindow al hacer clic en el marcador
    displayMarker.addListener('click', function() {
      infoWindow.open(displayMap, displayMarker);
      
      // Aplicar estilos después de abrir
      setTimeout(function() {
        applyInfoWindowStyles();
      }, 100);
    });

    // Abrir InfoWindow por defecto
    setTimeout(function() {
      infoWindow.open(displayMap, displayMarker);
      
      // Aplicar estilos después de abrir
      setTimeout(function() {
        applyInfoWindowStyles();
      }, 200);
    }, 500);

    // Función para aplicar estilos forzados al InfoWindow
    function applyInfoWindowStyles() {
      var infoWindowContent = document.querySelector('.gm-style-iw-d .hpcp-info-window');
      if (infoWindowContent) {
        infoWindowContent.style.color = '#333';
        
        var h4Elements = infoWindowContent.querySelectorAll('h4');
        h4Elements.forEach(function(h4) {
          h4.style.color = '#16182D';
          h4.style.fontWeight = 'bold';
        });
        
        var pElements = infoWindowContent.querySelectorAll('p');
        pElements.forEach(function(p) {
          p.style.color = '#333';
        });
        
        var strongElements = infoWindowContent.querySelectorAll('strong');
        strongElements.forEach(function(strong) {
          strong.style.color = '#16182D';
          strong.style.fontWeight = '600';
        });
      }
    }
  };

  // Función alternativa si initMap ya está definida
  window.initMapForDisplay = window.initDisplayMap;

  // Inicialización cuando el documento esté listo
  $(function(){
    // Si Google Maps ya está disponible
    if (typeof google !== 'undefined' && typeof google.maps !== 'undefined' && typeof hpcpMapData !== 'undefined') {
      setTimeout(function() {
        initDisplayMap();
      }, 100);
    }

    // Observar cambios en el DOM para mapas cargados dinámicamente
    if (typeof MutationObserver !== 'undefined') {
      var observer = new MutationObserver(function(mutations) {
        mutations.forEach(function(mutation) {
          if (mutation.type === 'childList') {
            var mapElement = document.querySelector('.hpcp-display-map');
            if (mapElement && !displayMapInitialized && typeof google !== 'undefined' && typeof hpcpMapData !== 'undefined') {
              setTimeout(initDisplayMap, 200);
            }
          }
        });
      });

      observer.observe(document.body, {
        childList: true,
        subtree: true
      });
    }
  });

  // Callback global alternativo
  window.hpcpInitDisplayMap = window.initDisplayMap;

})(jQuery);

// Función global para inicializar desde Google Maps callback
function initMap() {
  // Llamar a la función original si existe
  if (typeof window.originalInitMap === 'function') {
    window.originalInitMap();
  }
  
  // Llamar a la función de visualización
  if (typeof window.initDisplayMap === 'function') {
    window.initDisplayMap();
  }
}