<?php
/**
 * Clase para manejo de base de datos
 *
 * @package HunterPriceCRM
 */

// Bloquear acceso directo.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class HP_CRM_Database {

    /**
     * Crear todas las tablas necesarias
     */
    public static function create_tables() {
        global $wpdb;

        require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

        $charset_collate = $wpdb->get_charset_collate();

        // Tabla de prospectos
        $prospects_table = $wpdb->prefix . 'hp_crm_prospects';
        $prospects_sql = "CREATE TABLE $prospects_table (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            user_id bigint(20) NOT NULL,
            name varchar(255) NOT NULL,
            phone varchar(20) NOT NULL,
            email varchar(255) NOT NULL,
            status varchar(50) DEFAULT 'nuevo',
            notes text,
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            updated_at datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY (id),
            KEY user_id (user_id),
            KEY status (status)
        ) $charset_collate;";

        // Tabla de citas
        $appointments_table = $wpdb->prefix . 'hp_crm_appointments';
        $appointments_sql = "CREATE TABLE $appointments_table (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            prospect_id bigint(20) NOT NULL,
            user_id bigint(20) NOT NULL,
            title varchar(255) NOT NULL,
            description text,
            appointment_date datetime NOT NULL,
            status varchar(50) DEFAULT 'programada',
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (id),
            KEY prospect_id (prospect_id),
            KEY user_id (user_id),
            KEY appointment_date (appointment_date)
        ) $charset_collate;";

        // Tabla de llamadas
        $calls_table = $wpdb->prefix . 'hp_crm_calls';
        $calls_sql = "CREATE TABLE $calls_table (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            prospect_id bigint(20) NOT NULL,
            user_id bigint(20) NOT NULL,
            call_date datetime NOT NULL,
            call_time time,
            notes text,
            result varchar(100),
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (id),
            KEY prospect_id (prospect_id),
            KEY user_id (user_id),
            KEY call_date (call_date)
        ) $charset_collate;";

        // Tabla de propiedades de interés
        $interests_table = $wpdb->prefix . 'hp_crm_prospect_interests';
        $interests_sql = "CREATE TABLE $interests_table (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            prospect_id bigint(20) NOT NULL,
            property_id bigint(20) NOT NULL,
            notes text,
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (id),
            KEY prospect_id (prospect_id),
            KEY property_id (property_id),
            UNIQUE KEY prospect_property (prospect_id, property_id)
        ) $charset_collate;";

        // Tabla de eventos/notas
        $events_table = $wpdb->prefix . 'hp_crm_events';
        $events_sql = "CREATE TABLE $events_table (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            prospect_id bigint(20) NOT NULL,
            user_id bigint(20) NOT NULL,
            event_type varchar(50) NOT NULL,
            title varchar(255) NOT NULL,
            description text,
            event_date datetime NOT NULL,
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (id),
            KEY prospect_id (prospect_id),
            KEY user_id (user_id),
            KEY event_type (event_type),
            KEY event_date (event_date)
        ) $charset_collate;";

        require_once ABSPATH . 'wp-admin/includes/upgrade.php';
        
        dbDelta( $prospects_sql );
        dbDelta( $appointments_sql );
        dbDelta( $calls_sql );
        dbDelta( $interests_sql );
        dbDelta( $events_sql );

        // Guardar versión de BD
        update_option( 'hp_crm_db_version', '1.0' );
    }

    /**
     * Obtener tabla de prospectos
     */
    public static function get_prospects_table() {
        global $wpdb;
        return $wpdb->prefix . 'hp_crm_prospects';
    }

    /**
     * Obtener tabla de citas
     */
    public static function get_appointments_table() {
        global $wpdb;
        return $wpdb->prefix . 'hp_crm_appointments';
    }

    /**
     * Obtener tabla de llamadas
     */
    public static function get_calls_table() {
        global $wpdb;
        return $wpdb->prefix . 'hp_crm_calls';
    }

    /**
     * Obtener tabla de intereses
     */
    public static function get_interests_table() {
        global $wpdb;
        return $wpdb->prefix . 'hp_crm_prospect_interests';
    }

    /**
     * Obtener tabla de eventos
     */
    public static function get_events_table() {
        global $wpdb;
        return $wpdb->prefix . 'hp_crm_events';
    }
}