<?php
/**
 * Template: Dashboard Principal del CRM
 *
 * @package HunterPriceCRM
 */

// Bloquear acceso directo.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$statuses = HP_CRM_Prospects::get_available_statuses();
?>

<div class="hp-crm">
    <div class="hp-crm__container">
        
        <!-- Header -->
        <div class="hp-crm__header">
            <h1 class="hp-crm__header-title">Panel de Prospectos</h1>
            <div class="hp-crm__header-actions">
                <button class="hp-crm__button hp-crm__button--primary hp-crm__button--large hp-crm__button--create-prospect">
                    ➕ Crear Prospecto
                </button>
            </div>
        </div>

        <!-- Estadísticas -->
        <div class="hp-crm__stats">
            <div class="hp-crm__stats-card hp-crm__stats-card--total">
                <h3 class="hp-crm__stats-card-title">Total Prospectos</h3>
                <p class="hp-crm__stats-card-number">0</p>
            </div>
            <div class="hp-crm__stats-card hp-crm__stats-card--nuevo">
                <h3 class="hp-crm__stats-card-title">Nuevos</h3>
                <p class="hp-crm__stats-card-number">0</p>
            </div>
            <div class="hp-crm__stats-card hp-crm__stats-card--contactado hp-crm__stats-card--warning">
                <h3 class="hp-crm__stats-card-title">Contactados</h3>
                <p class="hp-crm__stats-card-number">0</p>
            </div>
            <div class="hp-crm__stats-card hp-crm__stats-card--interesado">
                <h3 class="hp-crm__stats-card-title">Interesados</h3>
                <p class="hp-crm__stats-card-number">0</p>
            </div>
            <div class="hp-crm__stats-card hp-crm__stats-card--seguimiento hp-crm__stats-card--success">
                <h3 class="hp-crm__stats-card-title">En seguimiento</h3>
                <p class="hp-crm__stats-card-number">0</p>
            </div>
            <div class="hp-crm__stats-card hp-crm__stats-card--vendido hp-crm__stats-card--success">
                <h3 class="hp-crm__stats-card-title">Vendidos</h3>
                <p class="hp-crm__stats-card-number">0</p>
            </div>
        </div>

        <!-- Buscador -->
        <div class="hp-crm__search">
            <span class="hp-crm__search-icon">🔍</span>
            <input type="text" class="hp-crm__search-input" placeholder="Buscar prospectos por nombre, teléfono o email...">
        </div>

        <!-- Tabla de Prospectos -->
        <div class="hp-crm__prospects">
            <div class="hp-crm__prospects-header">
                <h2 class="hp-crm__prospects-title">Mis Prospectos</h2>
            </div>
            
            <table class="hp-crm__prospects-table">
                <thead>
                    <tr>
                        <th>Nombre</th>
                        <th>Teléfono</th>
                        <th>Correo</th>
                        <th>Estatus</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- Los prospectos se cargan vía AJAX -->
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Modal: Crear Prospecto -->
<div id="create-prospect-modal" class="hp-crm__modal">
    <div class="hp-crm__modal-content">
        <div class="hp-crm__modal-header">
            <h3 class="hp-crm__modal-title">Crear Nuevo Prospecto</h3>
            <button class="hp-crm__modal-close" type="button">✕</button>
        </div>
        <div class="hp-crm__modal-body">
            <form id="hp-crm-prospect-form" class="hp-crm__form">
                <div class="hp-crm__form-group">
                    <label class="hp-crm__form-label hp-crm__form-label--required" for="prospect-name">Nombre completo</label>
                    <input type="text" id="prospect-name" name="name" class="hp-crm__form-input" required>
                </div>
                
                <div class="hp-crm__form-group">
                    <label class="hp-crm__form-label hp-crm__form-label--required" for="prospect-phone">Teléfono</label>
                    <input type="tel" id="prospect-phone" name="phone" class="hp-crm__form-input" required placeholder="5512345678">
                </div>
                
                <div class="hp-crm__form-group">
                    <label class="hp-crm__form-label hp-crm__form-label--required" for="prospect-email">Correo electrónico</label>
                    <input type="email" id="prospect-email" name="email" class="hp-crm__form-input" required>
                </div>
                
                <div class="hp-crm__form-group">
                    <label class="hp-crm__form-label" for="prospect-status">Estatus</label>
                    <select id="prospect-status" name="status" class="hp-crm__form-select">
                        <?php foreach ( $statuses as $key => $label ) : ?>
                            <option value="<?php echo esc_attr( $key ); ?>"><?php echo esc_html( $label ); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="hp-crm__form-group">
                    <label class="hp-crm__form-label" for="prospect-notes">Notas</label>
                    <textarea id="prospect-notes" name="notes" class="hp-crm__form-textarea" placeholder="Notas adicionales sobre el prospecto..."></textarea>
                </div>
            </form>
        </div>
        <div class="hp-crm__modal-footer">
            <button type="button" class="hp-crm__button hp-crm__modal-close">Cancelar</button>
            <button type="submit" form="hp-crm-prospect-form" class="hp-crm__button hp-crm__button--primary">Crear Prospecto</button>
        </div>
    </div>
</div>

<!-- Modal: Editar Prospecto -->
<div id="edit-prospect-modal" class="hp-crm__modal">
    <div class="hp-crm__modal-content">
        <div class="hp-crm__modal-header">
            <h3 class="hp-crm__modal-title">Editar Prospecto</h3>
            <button class="hp-crm__modal-close" type="button">✕</button>
        </div>
        <div class="hp-crm__modal-body">
            <form id="hp-crm-prospect-form" class="hp-crm__form">
                <input type="hidden" id="prospect-id" name="prospect_id">
                
                <div class="hp-crm__form-group">
                    <label class="hp-crm__form-label hp-crm__form-label--required" for="prospect-name">Nombre completo</label>
                    <input type="text" id="prospect-name" name="name" class="hp-crm__form-input" required>
                </div>
                
                <div class="hp-crm__form-group">
                    <label class="hp-crm__form-label hp-crm__form-label--required" for="prospect-phone">Teléfono</label>
                    <input type="tel" id="prospect-phone" name="phone" class="hp-crm__form-input" required>
                </div>
                
                <div class="hp-crm__form-group">
                    <label class="hp-crm__form-label hp-crm__form-label--required" for="prospect-email">Correo electrónico</label>
                    <input type="email" id="prospect-email" name="email" class="hp-crm__form-input" required>
                </div>
                
                <div class="hp-crm__form-group">
                    <label class="hp-crm__form-label" for="prospect-status">Estatus</label>
                    <select id="prospect-status" name="status" class="hp-crm__form-select">
                        <?php foreach ( $statuses as $key => $label ) : ?>
                            <option value="<?php echo esc_attr( $key ); ?>"><?php echo esc_html( $label ); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="hp-crm__form-group">
                    <label class="hp-crm__form-label" for="prospect-notes">Notas</label>
                    <textarea id="prospect-notes" name="notes" class="hp-crm__form-textarea"></textarea>
                </div>
            </form>
        </div>
        <div class="hp-crm__modal-footer">
            <button type="button" class="hp-crm__button hp-crm__modal-close">Cancelar</button>
            <button type="submit" form="hp-crm-prospect-form" class="hp-crm__button hp-crm__button--primary">Guardar Cambios</button>
        </div>
    </div>
</div>

<!-- Modal: Detalles del Prospecto -->
<div id="prospect-detail-modal" class="hp-crm__modal">
    <div class="hp-crm__modal-content" style="max-width: 800px;">
        <div class="hp-crm__modal-header">
            <h3 class="hp-crm__modal-title">
                Detalles del Prospecto - <span id="prospect-detail-name"></span>
            </h3>
            <button class="hp-crm__modal-close" type="button">✕</button>
        </div>
        <div class="hp-crm__modal-body">
            <!-- Información básica -->
            <div class="hp-crm__prospect-info" style="background: var(--hp-crm-gray-100); padding: var(--hp-crm-spacing-md); border-radius: var(--hp-crm-radius); margin-bottom: var(--hp-crm-spacing-lg);">
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: var(--hp-crm-spacing-md);">
                    <div>
                        <strong>Teléfono:</strong><br>
                        <span id="prospect-detail-phone"></span>
                    </div>
                    <div>
                        <strong>Email:</strong><br>
                        <span id="prospect-detail-email"></span>
                    </div>
                    <div>
                        <strong>Estatus:</strong><br>
                        <span id="prospect-detail-status"></span>
                    </div>
                </div>
                <div style="margin-top: var(--hp-crm-spacing-sm);">
                    <strong>Notas:</strong><br>
                    <span id="prospect-detail-notes"></span>
                </div>
            </div>

            <!-- Pestañas -->
            <div class="hp-crm__tabs">
                <nav class="hp-crm__tabs-nav">
                    <button class="hp-crm__tabs-nav-item hp-crm__tabs-nav-item--active" data-tab="appointments">
                        📅 Citas
                    </button>
                    <button class="hp-crm__tabs-nav-item" data-tab="calls">
                        📞 Llamadas
                    </button>
                    <button class="hp-crm__tabs-nav-item" data-tab="interests">
                        🏠 Propiedades
                    </button>
                    <button class="hp-crm__tabs-nav-item" data-tab="events">
                        📝 Eventos
                    </button>
                </nav>

                <!-- Tab: Citas -->
                <div class="hp-crm__tabs-pane hp-crm__tabs-pane--active" data-tab="appointments">
                    <div style="display: grid; grid-template-columns: 1fr 300px; gap: var(--hp-crm-spacing-lg);">
                        <div>
                            <h4>Citas Programadas</h4>
                            <div id="appointments-list"></div>
                        </div>
                        <div>
                            <h4>Nueva Cita</h4>
                            <form id="hp-crm-appointment-form" class="hp-crm__form hp-crm-detail-form">
                                <input type="hidden" name="prospect_id">
                                <div class="hp-crm__form-group">
                                    <label class="hp-crm__form-label" for="appointment-title">Título</label>
                                    <input type="text" id="appointment-title" name="title" class="hp-crm__form-input" required>
                                </div>
                                <div class="hp-crm__form-group">
                                    <label class="hp-crm__form-label" for="appointment-date">Fecha y hora</label>
                                    <input type="datetime-local" id="appointment-date" name="appointment_date" class="hp-crm__form-input" required>
                                </div>
                                <div class="hp-crm__form-group">
                                    <label class="hp-crm__form-label" for="appointment-description">Descripción</label>
                                    <textarea id="appointment-description" name="description" class="hp-crm__form-textarea"></textarea>
                                </div>
                                <button type="submit" class="hp-crm__button hp-crm__button--primary">Agregar Cita</button>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Tab: Llamadas -->
                <div class="hp-crm__tabs-pane" data-tab="calls">
                    <div style="display: grid; grid-template-columns: 1fr 300px; gap: var(--hp-crm-spacing-lg);">
                        <div>
                            <h4>Registro de Llamadas</h4>
                            <div id="calls-list"></div>
                        </div>
                        <div>
                            <h4>Registrar Llamada</h4>
                            <form id="hp-crm-call-form" class="hp-crm__form hp-crm-detail-form">
                                <input type="hidden" name="prospect_id">
                                <div class="hp-crm__form-group">
                                    <label class="hp-crm__form-label" for="call-date">Fecha</label>
                                    <input type="date" id="call-date" name="call_date" class="hp-crm__form-input" required>
                                </div>
                                <div class="hp-crm__form-group">
                                    <label class="hp-crm__form-label" for="call-time">Hora</label>
                                    <input type="time" id="call-time" name="call_time" class="hp-crm__form-input">
                                </div>
                                <div class="hp-crm__form-group">
                                    <label class="hp-crm__form-label" for="call-result">Resultado</label>
                                    <select id="call-result" name="result" class="hp-crm__form-select">
                                        <option value="">Seleccionar...</option>
                                        <option value="contestó">Contestó</option>
                                        <option value="no_contesto">No contestó</option>
                                        <option value="ocupado">Ocupado</option>
                                        <option value="buzón">Buzón de voz</option>
                                        <option value="interesado">Mostró interés</option>
                                        <option value="no_interesado">No interesado</option>
                                    </select>
                                </div>
                                <div class="hp-crm__form-group">
                                    <label class="hp-crm__form-label" for="call-notes">Notas</label>
                                    <textarea id="call-notes" name="notes" class="hp-crm__form-textarea"></textarea>
                                </div>
                                <button type="submit" class="hp-crm__button hp-crm__button--primary">Registrar Llamada</button>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Tab: Propiedades de Interés -->
                <div class="hp-crm__tabs-pane" data-tab="interests">
                    <div style="display: grid; grid-template-columns: 1fr 300px; gap: var(--hp-crm-spacing-lg);">
                        <div>
                            <h4>Propiedades de Interés</h4>
                            <div id="interests-list"></div>
                        </div>
                        <div>
                            <h4>Agregar Propiedad</h4>
                            <form id="hp-crm-interest-form" class="hp-crm__form hp-crm-detail-form">
                                <input type="hidden" name="prospect_id">
                                <input type="hidden" id="selected-property-id">
                                <div class="hp-crm__form-group">
                                    <label class="hp-crm__form-label" for="property-search">Buscar Propiedad</label>
                                    <input type="text" id="property-search" class="hp-crm__form-input" placeholder="Escribe el nombre de la propiedad...">
                                    <div id="property-search-results" style="display: none; border: 1px solid var(--hp-crm-gray-300); border-top: none; background: white; position: absolute; z-index: 100; width: 100%; max-height: 200px; overflow-y: auto;"></div>
                                </div>
                                <div class="hp-crm__form-group">
                                    <label class="hp-crm__form-label" for="interest-notes">Notas sobre el interés</label>
                                    <textarea id="interest-notes" name="notes" class="hp-crm__form-textarea"></textarea>
                                </div>
                                <button type="submit" class="hp-crm__button hp-crm__button--primary">Agregar Interés</button>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Tab: Eventos/Notas -->
                <div class="hp-crm__tabs-pane" data-tab="events">
                    <div style="display: grid; grid-template-columns: 1fr 300px; gap: var(--hp-crm-spacing-lg);">
                        <div>
                            <h4>Historial de Eventos</h4>
                            <div id="events-list"></div>
                        </div>
                        <div>
                            <h4>Agregar Evento</h4>
                            <form id="hp-crm-event-form" class="hp-crm__form hp-crm-detail-form">
                                <input type="hidden" name="prospect_id">
                                <div class="hp-crm__form-group">
                                    <label class="hp-crm__form-label" for="event-type">Tipo de evento</label>
                                    <select id="event-type" name="event_type" class="hp-crm__form-select">
                                        <option value="nota">Nota</option>
                                        <option value="seguimiento">Seguimiento</option>
                                        <option value="reunion">Reunión</option>
                                        <option value="visita">Visita</option>
                                        <option value="propuesta">Propuesta</option>
                                    </select>
                                </div>
                                <div class="hp-crm__form-group">
                                    <label class="hp-crm__form-label" for="event-title">Título</label>
                                    <input type="text" id="event-title" name="title" class="hp-crm__form-input" required>
                                </div>
                                <div class="hp-crm__form-group">
                                    <label class="hp-crm__form-label" for="event-date">Fecha</label>
                                    <input type="datetime-local" id="event-date" name="event_date" class="hp-crm__form-input">
                                </div>
                                <div class="hp-crm__form-group">
                                    <label class="hp-crm__form-label" for="event-description">Descripción</label>
                                    <textarea id="event-description" name="description" class="hp-crm__form-textarea"></textarea>
                                </div>
                                <button type="submit" class="hp-crm__button hp-crm__button--primary">Agregar Evento</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.hp-crm__property-result {
    padding: var(--hp-crm-spacing-sm);
    cursor: pointer;
    border-bottom: 1px solid var(--hp-crm-gray-200);
}

.hp-crm__property-result:hover {
    background: var(--hp-crm-gray-100);
}

.hp-crm__item {
    background: var(--hp-crm-gray-100);
    padding: var(--hp-crm-spacing-sm);
    border-radius: var(--hp-crm-radius);
    margin-bottom: var(--hp-crm-spacing-sm);
}

.hp-crm__item strong {
    display: block;
    margin-bottom: var(--hp-crm-spacing-xs);
}

.hp-crm__item small {
    color: var(--hp-crm-gray-700);
    font-size: 12px;
}

.hp-crm__loading-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(255, 255, 255, 0.8);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 9999;
}
</style>