<?php
/**
 * Template: Vista individual de prospecto
 *
 * @package HunterPriceCRM
 */

// Bloquear acceso directo.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$prospect_id = isset( $_GET['prospect_id'] ) ? intval( $_GET['prospect_id'] ) : 0;

if ( ! $prospect_id ) {
    echo '<div class="hp-crm__alert hp-crm__alert--error">ID de prospecto no válido</div>';
    return;
}

$prospect = HP_CRM_Prospects::get_prospect( $prospect_id );

if ( ! $prospect ) {
    echo '<div class="hp-crm__alert hp-crm__alert--error">Prospecto no encontrado o no tienes permisos para verlo</div>';
    return;
}

$appointments = HP_CRM_Prospects::get_prospect_appointments( $prospect_id );
$calls = HP_CRM_Prospects::get_prospect_calls( $prospect_id );
$interests = HP_CRM_Prospects::get_prospect_interests( $prospect_id );
$events = HP_CRM_Prospects::get_prospect_events( $prospect_id );
$statuses = HP_CRM_Prospects::get_available_statuses();
?>

<div class="hp-crm">
    <div class="hp-crm__container">
        
        <!-- Header del prospecto -->
        <div class="hp-crm__header">
            <h1 class="hp-crm__header-title"><?php echo esc_html( $prospect->name ); ?></h1>
            <div class="hp-crm__header-actions">
                <a href="https://wa.me/52<?php echo esc_attr( preg_replace( '/[^0-9]/', '', $prospect->phone ) ); ?>" 
                   target="_blank" 
                   class="hp-crm__button hp-crm__button--whatsapp">
                    📱 WhatsApp
                </a>
                <a href="mailto:<?php echo esc_attr( $prospect->email ); ?>" 
                   class="hp-crm__button">
                    ✉️ Email
                </a>
                <button class="hp-crm__button hp-crm__button--edit-prospect" data-prospect-id="<?php echo $prospect->id; ?>">
                    ✏️ Editar
                </button>
            </div>
        </div>

        <!-- Información básica -->
        <div class="hp-crm__prospect-detail">
            <div class="hp-crm__prospect-main">
                <div style="padding: var(--hp-crm-spacing-lg);">
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: var(--hp-crm-spacing-lg); margin-bottom: var(--hp-crm-spacing-lg);">
                        <div>
                            <h3>Información de Contacto</h3>
                            <p><strong>Teléfono:</strong> <?php echo esc_html( $prospect->phone ); ?></p>
                            <p><strong>Email:</strong> <?php echo esc_html( $prospect->email ); ?></p>
                            <p><strong>Estatus:</strong> 
                                <span class="hp-crm__status hp-crm__status--<?php echo esc_attr( $prospect->status ); ?>">
                                    <?php echo esc_html( $statuses[ $prospect->status ] ?? $prospect->status ); ?>
                                </span>
                            </p>
                        </div>
                        <div>
                            <h3>Fechas</h3>
                            <p><strong>Creado:</strong> <?php echo date( 'd/m/Y H:i', strtotime( $prospect->created_at ) ); ?></p>
                            <p><strong>Actualizado:</strong> <?php echo date( 'd/m/Y H:i', strtotime( $prospect->updated_at ) ); ?></p>
                        </div>
                    </div>

                    <?php if ( $prospect->notes ) : ?>
                        <div>
                            <h3>Notas</h3>
                            <p><?php echo nl2br( esc_html( $prospect->notes ) ); ?></p>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Pestañas de detalles -->
                <div class="hp-crm__tabs">
                    <nav class="hp-crm__tabs-nav">
                        <button class="hp-crm__tabs-nav-item hp-crm__tabs-nav-item--active" data-tab="appointments">
                            📅 Citas (<?php echo count( $appointments ); ?>)
                        </button>
                        <button class="hp-crm__tabs-nav-item" data-tab="calls">
                            📞 Llamadas (<?php echo count( $calls ); ?>)
                        </button>
                        <button class="hp-crm__tabs-nav-item" data-tab="interests">
                            🏠 Propiedades (<?php echo count( $interests ); ?>)
                        </button>
                        <button class="hp-crm__tabs-nav-item" data-tab="events">
                            📝 Eventos (<?php echo count( $events ); ?>)
                        </button>
                    </nav>

                    <!-- Contenido de las pestañas -->
                    <div style="padding: var(--hp-crm-spacing-lg);">
                        
                        <!-- Citas -->
                        <div class="hp-crm__tabs-pane hp-crm__tabs-pane--active" data-tab="appointments">
                            <h3>Citas Programadas</h3>
                            <?php if ( $appointments ) : ?>
                                <?php foreach ( $appointments as $appointment ) : ?>
                                    <div class="hp-crm__item">
                                        <strong><?php echo esc_html( $appointment->title ); ?></strong>
                                        <small><?php echo date( 'd/m/Y H:i', strtotime( $appointment->appointment_date ) ); ?></small>
                                        <?php if ( $appointment->description ) : ?>
                                            <p><?php echo nl2br( esc_html( $appointment->description ) ); ?></p>
                                        <?php endif; ?>
                                        <span class="hp-crm__status hp-crm__status--<?php echo esc_attr( $appointment->status ); ?>">
                                            <?php echo esc_html( $appointment->status ); ?>
                                        </span>
                                    </div>
                                <?php endforeach; ?>
                            <?php else : ?>
                                <p class="hp-crm__empty-message">No hay citas programadas</p>
                            <?php endif; ?>
                        </div>

                        <!-- Llamadas -->
                        <div class="hp-crm__tabs-pane" data-tab="calls">
                            <h3>Registro de Llamadas</h3>
                            <?php if ( $calls ) : ?>
                                <?php foreach ( $calls as $call ) : ?>
                                    <div class="hp-crm__item">
                                        <strong>Llamada - <?php echo date( 'd/m/Y', strtotime( $call->call_date ) ); ?></strong>
                                        <?php if ( $call->call_time ) : ?>
                                            <small><?php echo esc_html( $call->call_time ); ?></small>
                                        <?php endif; ?>
                                        <?php if ( $call->notes ) : ?>
                                            <p><?php echo nl2br( esc_html( $call->notes ) ); ?></p>
                                        <?php endif; ?>
                                        <?php if ( $call->result ) : ?>
                                            <span class="hp-crm__status"><?php echo esc_html( $call->result ); ?></span>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; ?>
                            <?php else : ?>
                                <p class="hp-crm__empty-message">No hay llamadas registradas</p>
                            <?php endif; ?>
                        </div>

                        <!-- Propiedades de interés -->
                        <div class="hp-crm__tabs-pane" data-tab="interests">
                            <h3>Propiedades de Interés</h3>
                            <?php if ( $interests ) : ?>
                                <?php foreach ( $interests as $interest ) : ?>
                                    <div class="hp-crm__item">
                                        <strong><?php echo esc_html( $interest->property_name ?: 'Propiedad #' . $interest->property_id ); ?></strong>
                                        <?php if ( $interest->notes ) : ?>
                                            <p><?php echo nl2br( esc_html( $interest->notes ) ); ?></p>
                                        <?php endif; ?>
                                        <small>Agregado: <?php echo date( 'd/m/Y', strtotime( $interest->created_at ) ); ?></small>
                                    </div>
                                <?php endforeach; ?>
                            <?php else : ?>
                                <p class="hp-crm__empty-message">No hay propiedades de interés</p>
                            <?php endif; ?>
                        </div>

                        <!-- Eventos -->
                        <div class="hp-crm__tabs-pane" data-tab="events">
                            <h3>Historial de Eventos</h3>
                            <?php if ( $events ) : ?>
                                <?php foreach ( $events as $event ) : ?>
                                    <div class="hp-crm__item">
                                        <strong><?php echo esc_html( $event->title ); ?></strong>
                                        <small><?php echo date( 'd/m/Y H:i', strtotime( $event->event_date ) ); ?></small>
                                        <?php if ( $event->description ) : ?>
                                            <p><?php echo nl2br( esc_html( $event->description ) ); ?></p>
                                        <?php endif; ?>
                                        <span class="hp-crm__status"><?php echo esc_html( $event->event_type ); ?></span>
                                    </div>
                                <?php endforeach; ?>
                            <?php else : ?>
                                <p class="hp-crm__empty-message">No hay eventos registrados</p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Sidebar con acciones rápidas -->
            <div class="hp-crm__prospect-sidebar">
                <h3>Acciones Rápidas</h3>
                
                <div style="margin-bottom: var(--hp-crm-spacing-md);">
                    <a href="https://wa.me/52<?php echo esc_attr( preg_replace( '/[^0-9]/', '', $prospect->phone ) ); ?>" 
                       target="_blank" 
                       class="hp-crm__button hp-crm__button--whatsapp" 
                       style="width: 100%; justify-content: center; margin-bottom: var(--hp-crm-spacing-xs);">
                        📱 Enviar WhatsApp
                    </a>
                    <a href="mailto:<?php echo esc_attr( $prospect->email ); ?>" 
                       class="hp-crm__button" 
                       style="width: 100%; justify-content: center;">
                        ✉️ Enviar Email
                    </a>
                </div>

                <div style="margin-bottom: var(--hp-crm-spacing-md);">
                    <button class="hp-crm__button hp-crm__button--primary" 
                            style="width: 100%; justify-content: center; margin-bottom: var(--hp-crm-spacing-xs);"
                            onclick="alert('Función para agregar cita - pendiente de implementar')">
                        📅 Agregar Cita
                    </button>
                    <button class="hp-crm__button hp-crm__button--success" 
                            style="width: 100%; justify-content: center;"
                            onclick="alert('Función para registrar llamada - pendiente de implementar')">
                        📞 Registrar Llamada
                    </button>
                </div>

                <div>
                    <button class="hp-crm__button hp-crm__button--edit-prospect" 
                            data-prospect-id="<?php echo $prospect->id; ?>"
                            style="width: 100%; justify-content: center; margin-bottom: var(--hp-crm-spacing-xs);">
                        ✏️ Editar Prospecto
                    </button>
                    <button class="hp-crm__button hp-crm__button--danger hp-crm__button--delete-prospect" 
                            data-prospect-id="<?php echo $prospect->id; ?>"
                            style="width: 100%; justify-content: center;">
                        🗑️ Eliminar Prospecto
                    </button>
                </div>
            </div>
        </div>

        <!-- Botón de regreso -->
        <div style="margin-top: var(--hp-crm-spacing-lg);">
            <a href="#" onclick="history.back()" class="hp-crm__button">
                ← Regresar a Prospectos
            </a>
        </div>
    </div>
</div>

<!-- Incluir los mismos modales del dashboard para editar -->
<?php include HP_CRM_PLUGIN_DIR . 'templates/dashboard.php'; ?>