<?php
/**
 * Test básico para verificar AJAX
 * Solo para debugging - eliminar en producción
 */

// Hook simple de prueba
add_action( 'wp_ajax_hp_crm_test', 'hp_crm_test_ajax' );

function hp_crm_test_ajax() {
    wp_send_json_success( array(
        'message' => 'AJAX funcionando correctamente',
        'time' => current_time( 'mysql' ),
        'user' => is_user_logged_in() ? wp_get_current_user()->display_name : 'No logueado',
        'nonce_check' => isset( $_POST['nonce'] ) ? wp_verify_nonce( $_POST['nonce'], 'hp_crm_nonce' ) : 'No nonce'
    ) );
}

// Agregar al plugin principal si no existe
if ( ! function_exists( 'hp_crm_add_test_ajax' ) ) {
    function hp_crm_add_test_ajax() {
        ?>
        <script>
        function testAjax() {
            console.log('HP_CRM: Iniciando test de AJAX...');
            
            jQuery.ajax({
                url: hp_crm_ajax.ajax_url,
                type: 'POST',
                data: {
                    action: 'hp_crm_test',
                    nonce: hp_crm_ajax.nonce
                },
                success: function(response) {
                    console.log('HP_CRM: Test AJAX exitoso:', response);
                    alert('Test AJAX exitoso: ' + response.data.message);
                },
                error: function(xhr, status, error) {
                    console.error('HP_CRM: Test AJAX falló:', xhr, status, error);
                    alert('Test AJAX falló: ' + xhr.status + ' - ' + error);
                }
            });
        }
        
        // Agregar botón de test
        jQuery(document).ready(function($) {
            $('body').append('<button onclick="testAjax()" style="position:fixed;top:10px;right:10px;z-index:9999;background:red;color:white;padding:10px;">Test AJAX</button>');
        });
        </script>
        <?php
    }
    add_action( 'wp_footer', 'hp_crm_add_test_ajax' );
}
?>