(function(){
  'use strict';

  function initOne(entry){
    var el = document.getElementById(entry.mapId);
    if(!el){ return; }
    try {
      var center = { lat: Number(entry.lat), lng: Number(entry.lng) };
      var map = new google.maps.Map(el, {
        zoom: Number(entry.zoom) || 15,
        center: center,
        mapTypeId: 'roadmap',
        fullscreenControl: true
      });
      var marker = new google.maps.Marker({
        position: center,
        map: map
      });
      if(entry.text){
        var infowindow = new google.maps.InfoWindow({ content: String(entry.text) });
        marker.addListener('click', function(){ infowindow.open({anchor: marker, map}); });
        // Abre el infoWindow de inicio
        infowindow.open({anchor: marker, map});
      }
    } catch(e){
      // fail silent
      console && console.warn && console.warn('HPDM map error:', e);
    }
  }

  function initAll(){
    if(!window.HPDM_MAPS || !Array.isArray(window.HPDM_MAPS)) return;
    // clona y vacía la cola
    var queue = window.HPDM_MAPS.slice();
    window.HPDM_MAPS.length = 0;
    for(var i=0;i<queue.length;i++){
      initOne(queue[i]);
    }
  }

  // Callback oficial para Google Maps
  window.HPDM_initMaps = function(){
    initAll();
    // En caso de que se agreguen más instancias dinámicamente
    window.HPDM_initMapsImmediate = initAll;
  };

})();