<?php
/**
 * Plugin Name: Hunter Price - Desplegado Mapa
 * Description: Muestra un mapa de Google con un marcador usando metadatos de latitud, longitud y dirección. Incluye página de ajustes para el API Key.
 * Version: 1.0.0
 * Author: Hunter Price Mx
 * Requires at least: 5.5
 * Requires PHP: 7.3
 * Text Domain: hp-desplegado-mapa
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

define( 'HPDM_VERSION', '1.0.0' );
define( 'HPDM_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'HPDM_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

// Admin and Frontend classes
require_once HPDM_PLUGIN_DIR . 'includes/class-hpdm-admin.php';
require_once HPDM_PLUGIN_DIR . 'includes/class-hpdm-frontend.php';

class HunterPrice_DesplegadoMapa {

    private static $instance = null;

    public static function instance() {
        if ( self::$instance === null ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        new HPDM_Admin();
        new HPDM_Frontend();
    }
}

function hpdm_init_plugin() {
    HunterPrice_DesplegadoMapa::instance();
}
add_action( 'plugins_loaded', 'hpdm_init_plugin' );