<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class HPDM_Admin {

    const OPTION_KEY = 'hpdm_google_maps_api_key';

    public function __construct() {
        add_action( 'admin_menu', [ $this, 'add_settings_page' ] );
        add_action( 'admin_init', [ $this, 'register_settings' ] );
    }

    public function add_settings_page() {
        add_options_page(
            __( 'HP Desplegado Mapa', 'hp-desplegado-mapa' ),
            __( 'HP Desplegado Mapa', 'hp-desplegado-mapa' ),
            'manage_options',
            'hpdm-settings',
            [ $this, 'render_settings_page' ]
        );
    }

    public function register_settings() {
        register_setting(
            'hpdm_settings_group',
            self::OPTION_KEY,
            [
                'type' => 'string',
                'sanitize_callback' => 'sanitize_text_field',
                'default' => ''
            ]
        );

        add_settings_section(
            'hpdm_main_section',
            __( 'Configuración principal', 'hp-desplegado-mapa' ),
            function() {
                echo '<p>' . esc_html__( 'Introduce tu Google Maps JavaScript API Key. Se usará al renderizar el shortcode del mapa.', 'hp-desplegado-mapa' ) . '</p>';
            },
            'hpdm-settings'
        );

        add_settings_field(
            'hpdm_api_key_field',
            __( 'Google Maps API Key', 'hp-desplegado-mapa' ),
            [ $this, 'api_key_field_cb' ],
            'hpdm-settings',
            'hpdm_main_section'
        );
    }

    public function api_key_field_cb() {
        $value = get_option( self::OPTION_KEY, '' );
        echo '<input type="text" id="hpdm_api_key" name="' . esc_attr( self::OPTION_KEY ) . '" value="' . esc_attr( $value ) . '" class="regular-text" />';
        echo '<p class="description">' . sprintf(
            wp_kses_post( __( 'Necesitas habilitar <a href="%s" target="_blank" rel="noopener">Maps JavaScript API</a> en Google Cloud y restringir tu clave.', 'hp-desplegado-mapa' ) ),
            esc_url( 'https://console.cloud.google.com/apis/library/maps-backend.googleapis.com' )
        ) . '</p>';
    }

    public function render_settings_page() {
        if ( ! current_user_can( 'manage_options' ) ) {
            return;
        }
        ?>
        <div class="wrap">
            <h1><?php echo esc_html__( 'Hunter Price - Desplegado Mapa', 'hp-desplegado-mapa' ); ?></h1>
            <form method="post" action="options.php">
                <?php
                    settings_fields( 'hpdm_settings_group' );
                    do_settings_sections( 'hpdm-settings' );
                    submit_button();
                ?>
            </form>
            <hr />
            <h2><?php esc_html_e( 'Uso del shortcode', 'hp-desplegado-mapa' ); ?></h2>
            <p><code>[hp_desplegado_mapa]</code></p>
            <p><?php esc_html_e( 'Atributos opcionales:', 'hp-desplegado-mapa' ); ?></p>
            <ul>
                <li><code>post_id</code> — <?php esc_html_e( 'ID del post (por defecto, el actual).', 'hp-desplegado-mapa' ); ?></li>
                <li><code>lat_key</code> — <?php esc_html_e( 'Meta key para latitud (por defecto: latitud).', 'hp-desplegado-mapa' ); ?></li>
                <li><code>lng_key</code> — <?php esc_html_e( 'Meta key para longitud (por defecto: longitud).', 'hp-desplegado-mapa' ); ?></li>
                <li><code>text_key</code> — <?php esc_html_e( 'Meta key para el texto del marcador (por defecto: _address).', 'hp-desplegado-mapa' ); ?></li>
                <li><code>height</code> — <?php esc_html_e( 'Altura del mapa (por defecto: 350px).', 'hp-desplegado-mapa' ); ?></li>
                <li><code>zoom</code> — <?php esc_html_e( 'Nivel de zoom (por defecto: 15).', 'hp-desplegado-mapa' ); ?></li>
            </ul>
            <p><?php esc_html_e( 'Ejemplo:', 'hp-desplegado-mapa' ); ?> <code>[hp_desplegado_mapa post_id="123" lat_key="latitud" lng_key="longitud" text_key="_address" height="420px" zoom="16"]</code></p>
            <p><strong><?php esc_html_e( 'BEM:', 'hp-desplegado-mapa' ); ?></strong> <?php esc_html_e( 'El contenedor usa clases BEM: .hpdm-map, .hpdm-map__container, .hpdm-map__inner.', 'hp-desplegado-mapa' ); ?></p>
        </div>
        <?php
    }
}