<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class HPDM_Frontend {

    public function __construct() {
        add_shortcode( 'hp_desplegado_mapa', [ $this, 'render_map_shortcode' ] );
        add_action( 'wp_enqueue_scripts', [ $this, 'register_assets' ] );
    }

    public function register_assets() {
        wp_register_style( 'hpdm-style', HPDM_PLUGIN_URL . 'assets/css/hpdm-style.css', [], HPDM_VERSION );
        wp_register_script( 'hpdm-map', HPDM_PLUGIN_URL . 'assets/js/hpdm-map.js', [], HPDM_VERSION, true );
    }

    public function render_map_shortcode( $atts ) {
        $atts = shortcode_atts( [
            'post_id' => get_the_ID(),
            'lat_key' => 'latitud',
            'lng_key' => 'longitud',
            'text_key' => '_address',
            'height'  => '350px',
            'zoom'    => '15',
        ], $atts, 'hp_desplegado_mapa' );

        $post_id = absint( $atts['post_id'] );

        if ( ! $post_id ) {
            return '<p>' . esc_html__( 'No se encontró el post para obtener los metadatos.', 'hp-desplegado-mapa' ) . '</p>';
        }

        $lat = get_post_meta( $post_id, $atts['lat_key'], true );
        $lng = get_post_meta( $post_id, $atts['lng_key'], true );
        $text = get_post_meta( $post_id, $atts['text_key'], true );
        
        // Obtener el título del post
        $post_title = get_the_title( $post_id );

        if ( $lat === '' || $lng === '' ) {
            return '<p>' . esc_html__( 'Faltan metadatos de latitud/longitud.', 'hp-desplegado-mapa' ) . '</p>';
        }

        $api_key = get_option( HPDM_Admin::OPTION_KEY, '' );
        if ( empty( $api_key ) ) {
            return '<p>' . esc_html__( 'Falta configurar la Google Maps API Key en Ajustes → HP Desplegado Mapa.', 'hp-desplegado-mapa' ) . '</p>';
        }

        // Enqueue assets only when needed
        wp_enqueue_style( 'hpdm-style' );
        wp_enqueue_script( 'hpdm-map' );

        // Enqueue Google Maps API with callback
        $maps_url = add_query_arg( [
            'key' => $api_key,
            'callback' => 'HPDM_initMaps',
        ], 'https://maps.googleapis.com/maps/api/js' );

        wp_enqueue_script( 'google-maps', $maps_url, [], null, true );

        // Crear el contenido del popup con título y dirección
        $popup_content = '<div class="hpdm-info-window">';
        if ( ! empty( $post_title ) ) {
            $popup_content .= '<div class="hpdm-title">' . esc_html( $post_title ) . '</div>';
        }
        if ( ! empty( $text ) ) {
            $popup_content .= '<div class="hpdm-address">' . wp_kses_post( $text ) . '</div>';
        }
        $popup_content .= '</div>';

        // Data for JS
        $data = [
            'lat'   => (float) $lat,
            'lng'   => (float) $lng,
            'text'  => $popup_content,
            'zoom'  => (int) $atts['zoom'],
            'mapId' => 'hpdm-map-' . $post_id . '-' . wp_generate_password( 6, false ),
        ];

        ob_start();
        ?>
        <div class="hpdm-map">
            <div class="hpdm-map__container" style="height: <?php echo esc_attr( $atts['height'] ); ?>;">
                <div id="<?php echo esc_attr( $data['mapId'] ); ?>" class="hpdm-map__inner" aria-label="<?php echo esc_attr__( 'Mapa de ubicación', 'hp-desplegado-mapa' ); ?>"></div>
            </div>
        </div>
        <script>
            window.HPDM_MAPS = window.HPDM_MAPS || [];
            window.HPDM_MAPS.push(<?php echo wp_json_encode( $data ); ?>);
            if (typeof window.google !== 'undefined' && window.google.maps) {
                // Si el API ya está cargado por cualquier razón, inicializa de inmediato
                if (typeof window.HPDM_initMapsImmediate === 'function') {
                    window.HPDM_initMapsImmediate();
                }
            }
        </script>
        <?php
        return ob_get_clean();
    }
}