(function(){ 
    'use strict'; 
    
    document.addEventListener('DOMContentLoaded', function() {
        const tabs = document.querySelectorAll('.hpue__tab');
        const contents = document.querySelectorAll('.hpue__tab-content');
        
        tabs.forEach(tab => {
            tab.addEventListener('click', function() {
                const target = this.dataset.tab;
                
                // Remove active class from all tabs and contents
                tabs.forEach(t => t.classList.remove('active'));
                contents.forEach(c => c.classList.remove('active'));
                
                // Add active class to clicked tab and corresponding content
                this.classList.add('active');
                document.getElementById(target).classList.add('active');
            });
        });
        
        // Activate first tab by default
        if (tabs.length > 0) {
            tabs[0].classList.add('active');
            if (contents.length > 0) {
                contents[0].classList.add('active');
            }
        }
    });
})();