<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class HPUE_Form {

    public function __construct() {
        add_shortcode( 'hp-editar-usuario', [ $this, 'render_shortcode' ] );
        add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_assets' ] );
        add_action( 'init', [ $this, 'handle_submit' ] );
    }

    public function enqueue_assets() {
        wp_register_style( 'hpue-style', HPUE_URL . 'assets/css/hpue.css', [], HPUE_VERSION );
        wp_register_script( 'hpue-script', HPUE_URL . 'assets/js/hpue.js', [], HPUE_VERSION, true );
    }

    public function render_shortcode( $atts ) {
        if ( ! is_user_logged_in() ) {
            return '<p class="hpue hpue--notice">'. esc_html__('Debes iniciar sesión para editar tus datos.', 'hp-editar-usuario') .'</p>';
        }

        $user = wp_get_current_user();
        wp_enqueue_style( 'hpue-style' );
        wp_enqueue_script( 'hpue-script' );

        $nonce = wp_create_nonce( 'hpue_update_user' );

        $meta_keys = ['profile-picture','photo','country','languages','phone','position','about-me','link_de_facebook','link_de_whatsapp','link_de_instagram','email'];
        $m = [];
        foreach ( $meta_keys as $k ) { $m[$k] = get_user_meta( $user->ID, $k, true ); }

        $billing = ['billing_first_name','billing_last_name','billing_company','billing_address_1','billing_address_2','billing_city','billing_state','billing_postcode','billing_country','billing_phone','billing_email'];
        $shipping = ['shipping_first_name','shipping_last_name','shipping_company','shipping_address_1','shipping_address_2','shipping_city','shipping_state','shipping_postcode','shipping_country'];
        $b = []; $s = [];
        foreach ( $billing as $k ) { $b[$k] = get_user_meta( $user->ID, $k, true ); }
        foreach ( $shipping as $k ) { $s[$k] = get_user_meta( $user->ID, $k, true ); }

        $avatar_id = intval( $m['profile-picture'] );
        $avatar_url = $avatar_id ? wp_get_attachment_image_url( $avatar_id, 'medium' ) : '';
        
        $photo_id = intval( $m['photo'] );
        $photo_url = $photo_id ? wp_get_attachment_image_url( $photo_id, 'medium' ) : '';

        ob_start(); ?>
        <form class="hpue" id="hpue-form" method="post" enctype="multipart/form-data">
            <input type="hidden" name="hpue_action" value="update_user" />
            <input type="hidden" name="hpue_nonce" value="<?php echo esc_attr( $nonce ); ?>" />

            <!-- Tabs Navigation -->
            <div class="hpue__tabs">
                <button type="button" class="hpue__tab" data-tab="tab-personal"><?php esc_html_e('Datos Personales', 'hp-editar-usuario'); ?></button>
                <button type="button" class="hpue__tab" data-tab="tab-images"><?php esc_html_e('Imágenes', 'hp-editar-usuario'); ?></button>
                <button type="button" class="hpue__tab" data-tab="tab-billing"><?php esc_html_e('Facturación', 'hp-editar-usuario'); ?></button>
                <button type="button" class="hpue__tab" data-tab="tab-shipping"><?php esc_html_e('Envío', 'hp-editar-usuario'); ?></button>
            </div>

            <!-- Tab 1: Datos Personales -->
            <div id="tab-personal" class="hpue__tab-content">
                <h2 class="hpue__title"><?php esc_html_e('Datos de cuenta', 'hp-editar-usuario'); ?></h2>
                <div class="hpue__grid">
                    <div class="hpue__field">
                        <label class="hpue__label"><?php esc_html_e('Nombre', 'hp-editar-usuario'); ?></label>
                        <input class="hpue__input" type="text" name="first_name" value="<?php echo esc_attr( $user->first_name ); ?>" />
                    </div>
                    <div class="hpue__field">
                        <label class="hpue__label"><?php esc_html_e('Apellidos', 'hp-editar-usuario'); ?></label>
                        <input class="hpue__input" type="text" name="last_name" value="<?php echo esc_attr( $user->last_name ); ?>" />
                    </div>
                    <div class="hpue__field">
                        <label class="hpue__label"><?php esc_html_e('Email (cuenta)', 'hp-editar-usuario'); ?></label>
                        <input class="hpue__input" type="email" name="user_email" value="<?php echo esc_attr( $user->user_email ); ?>" />
                    </div>
                    <div class="hpue__field">
                        <label class="hpue__label"><?php esc_html_e('Web', 'hp-editar-usuario'); ?></label>
                        <input class="hpue__input" type="url" name="user_url" value="<?php echo esc_attr( $user->user_url ); ?>" />
                    </div>
                </div>

                <div class="hpue__grid hpue__grid--3">
                    <div class="hpue__field">
                        <label class="hpue__label"><?php esc_html_e('País (country)', 'hp-editar-usuario'); ?></label>
                        <input class="hpue__input" type="text" name="meta[country]" value="<?php echo esc_attr( $m['country'] ); ?>" placeholder="MX, US, etc." />
                    </div>
                    <div class="hpue__field">
                        <label class="hpue__label"><?php esc_html_e('Idiomas (languages)', 'hp-editar-usuario'); ?></label>
                        <input class="hpue__input" type="text" name="meta[languages]" value="<?php echo esc_attr( $m['languages'] ); ?>" placeholder="es,en,fr" />
                    </div>
                    <div class="hpue__field">
                        <label class="hpue__label"><?php esc_html_e('Teléfono (phone)', 'hp-editar-usuario'); ?></label>
                        <input class="hpue__input" type="tel" name="meta[phone]" value="<?php echo esc_attr( $m['phone'] ? $m['phone'] : $b['billing_phone'] ); ?>" placeholder="+52..." />
                        <small class="hpue__help"><?php esc_html_e('Se sincroniza con WooCommerce (billing_phone).', 'hp-editar-usuario'); ?></small>
                    </div>
                </div>

                <div class="hpue__grid">
                    <div class="hpue__field">
                        <label class="hpue__label"><?php esc_html_e('Puesto / Cargo (position)', 'hp-editar-usuario'); ?></label>
                        <input class="hpue__input" type="text" name="meta[position]" value="<?php echo esc_attr( $m['position'] ); ?>" />
                    </div>
                    <div class="hpue__field">
                        <label class="hpue__label"><?php esc_html_e('Email alterno (meta: email)', 'hp-editar-usuario'); ?></label>
                        <input class="hpue__input" type="email" name="meta[email]" value="<?php echo esc_attr( $m['email'] ); ?>" />
                        <small class="hpue__help"><?php esc_html_e('Se sincroniza con WooCommerce (billing_email).', 'hp-editar-usuario'); ?></small>
                    </div>
                </div>

                <div class="hpue__field">
                    <label class="hpue__label"><?php esc_html_e('Acerca de ti (about-me)', 'hp-editar-usuario'); ?></label>
                    <textarea class="hpue__textarea" name="meta[about-me]" rows="5"><?php echo esc_textarea( $m['about-me'] ? $m['about-me'] : $user->description ); ?></textarea>
                    <small class="hpue__help"><?php esc_html_e('Se guardará también en la biografía del perfil (description).', 'hp-editar-usuario'); ?></small>
                </div>

                <div class="hpue__grid">
                    <div class="hpue__field">
                        <label class="hpue__label"><?php esc_html_e('Facebook', 'hp-editar-usuario'); ?></label>
                        <input class="hpue__input" type="url" name="meta[link_de_facebook]" value="<?php echo esc_attr( $m['link_de_facebook'] ); ?>" placeholder="https://facebook.com/..." />
                    </div>
                    <div class="hpue__field">
                        <label class="hpue__label"><?php esc_html_e('WhatsApp', 'hp-editar-usuario'); ?></label>
                        <input class="hpue__input" type="url" name="meta[link_de_whatsapp]" value="<?php echo esc_attr( $m['link_de_whatsapp'] ); ?>" placeholder="https://wa.me/52..." />
                    </div>
                    <div class="hpue__field">
                        <label class="hpue__label"><?php esc_html_e('Instagram', 'hp-editar-usuario'); ?></label>
                        <input class="hpue__input" type="url" name="meta[link_de_instagram]" value="<?php echo esc_attr( $m['link_de_instagram'] ); ?>" placeholder="https://instagram.com/..." />
                    </div>
                </div>
            </div>

            <!-- Tab 2: Imágenes -->
            <div id="tab-images" class="hpue__tab-content">
                <h2 class="hpue__title"><?php esc_html_e('Gestión de imágenes', 'hp-editar-usuario'); ?></h2>
                
                <div class="hpue__grid">
                    <div class="hpue__field hpue__field--file">
                        <label class="hpue__label"><?php esc_html_e('Logo de empresa (profile-picture)', 'hp-editar-usuario'); ?></label>
                        <?php if ( $avatar_url ) : ?>
                            <img class="hpue__avatar" src="<?php echo esc_url( $avatar_url ); ?>" alt="" />
                        <?php endif; ?>
                        <input class="hpue__input" type="file" accept="image/*" name="profile_picture_file" />
                        <small class="hpue__help"><?php esc_html_e('Se sube a la librería de medios y se guarda el ID en el meta profile-picture.', 'hp-editar-usuario'); ?></small>
                    </div>

                    <div class="hpue__field hpue__field--file">
                        <label class="hpue__label"><?php esc_html_e('Foto personal (photo)', 'hp-editar-usuario'); ?></label>
                        <?php if ( $photo_url ) : ?>
                            <img class="hpue__avatar" src="<?php echo esc_url( $photo_url ); ?>" alt="" />
                        <?php endif; ?>
                        <input class="hpue__input" type="file" accept="image/*" name="photo_file" />
                        <small class="hpue__help"><?php esc_html_e('Se sube a la librería de medios y se guarda el ID en el meta photo.', 'hp-editar-usuario'); ?></small>
                    </div>
                </div>
            </div>

            <!-- Tab 3: Dirección de facturación -->
            <div id="tab-billing" class="hpue__tab-content">
                <h2 class="hpue__title"><?php esc_html_e('Dirección de facturación', 'hp-editar-usuario'); ?></h2>
                <div class="hpue__grid">
                    <div class="hpue__field"><label class="hpue__label">Nombre</label><input class="hpue__input" name="billing[billing_first_name]" value="<?php echo esc_attr($b['billing_first_name']); ?>"></div>
                    <div class="hpue__field"><label class="hpue__label">Apellidos</label><input class="hpue__input" name="billing[billing_last_name]" value="<?php echo esc_attr($b['billing_last_name']); ?>"></div>
                    <div class="hpue__field"><label class="hpue__label">Empresa</label><input class="hpue__input" name="billing[billing_company]" value="<?php echo esc_attr($b['billing_company']); ?>"></div>
                    <div class="hpue__field"><label class="hpue__label">Dirección 1</label><input class="hpue__input" name="billing[billing_address_1]" value="<?php echo esc_attr($b['billing_address_1']); ?>"></div>
                    <div class="hpue__field"><label class="hpue__label">Dirección 2</label><input class="hpue__input" name="billing[billing_address_2]" value="<?php echo esc_attr($b['billing_address_2']); ?>"></div>
                    <div class="hpue__field"><label class="hpue__label">Ciudad</label><input class="hpue__input" name="billing[billing_city]" value="<?php echo esc_attr($b['billing_city']); ?>"></div>
                    <div class="hpue__field"><label class="hpue__label">Estado/Provincia</label><input class="hpue__input" name="billing[billing_state]" value="<?php echo esc_attr($b['billing_state']); ?>"></div>
                    <div class="hpue__field"><label class="hpue__label">C.P.</label><input class="hpue__input" name="billing[billing_postcode]" value="<?php echo esc_attr($b['billing_postcode']); ?>"></div>
                    <div class="hpue__field"><label class="hpue__label">País</label><input class="hpue__input" name="billing[billing_country]" value="<?php echo esc_attr($b['billing_country']); ?>" placeholder="MX, US, ..." ></div>
                    <div class="hpue__field"><label class="hpue__label">Teléfono</label><input class="hpue__input" name="billing[billing_phone]" value="<?php echo esc_attr($b['billing_phone']); ?>"></div>
                    <div class="hpue__field"><label class="hpue__label">Email facturación</label><input class="hpue__input" type="email" name="billing[billing_email]" value="<?php echo esc_attr($b['billing_email']); ?>"></div>
                </div>
            </div>

            <!-- Tab 4: Dirección de envío -->
            <div id="tab-shipping" class="hpue__tab-content">
                <h2 class="hpue__title"><?php esc_html_e('Dirección de envío', 'hp-editar-usuario'); ?></h2>
                <div class="hpue__grid">
                    <div class="hpue__field"><label class="hpue__label">Nombre</label><input class="hpue__input" name="shipping[shipping_first_name]" value="<?php echo esc_attr($s['shipping_first_name']); ?>"></div>
                    <div class="hpue__field"><label class="hpue__label">Apellidos</label><input class="hpue__input" name="shipping[shipping_last_name]" value="<?php echo esc_attr($s['shipping_last_name']); ?>"></div>
                    <div class="hpue__field"><label class="hpue__label">Empresa</label><input class="hpue__input" name="shipping[shipping_company]" value="<?php echo esc_attr($s['shipping_company']); ?>"></div>
                    <div class="hpue__field"><label class="hpue__label">Dirección 1</label><input class="hpue__input" name="shipping[shipping_address_1]" value="<?php echo esc_attr($s['shipping_address_1']); ?>"></div>
                    <div class="hpue__field"><label class="hpue__label">Dirección 2</label><input class="hpue__input" name="shipping[shipping_address_2]" value="<?php echo esc_attr($s['shipping_address_2']); ?>"></div>
                    <div class="hpue__field"><label class="hpue__label">Ciudad</label><input class="hpue__input" name="shipping[shipping_city]" value="<?php echo esc_attr($s['shipping_city']); ?>"></div>
                    <div class="hpue__field"><label class="hpue__label">Estado/Provincia</label><input class="hpue__input" name="shipping[shipping_state]" value="<?php echo esc_attr($s['shipping_state']); ?>"></div>
                    <div class="hpue__field"><label class="hpue__label">C.P.</label><input class="hpue__input" name="shipping[shipping_postcode]" value="<?php echo esc_attr($s['shipping_postcode']); ?>"></div>
                    <div class="hpue__field"><label class="hpue__label">País</label><input class="hpue__input" name="shipping[shipping_country]" value="<?php echo esc_attr($s['shipping_country']); ?>" placeholder="MX, US, ..." ></div>
                </div>
            </div>

            <div class="hpue__actions">
                <button type="submit" class="hpue__btn hpue__btn--primary"><?php esc_html_e('Guardar cambios', 'hp-editar-usuario'); ?></button>
            </div>
        </form>
        <?php
        if ( isset($_GET['hpue_saved']) ) {
            echo '<div class="hpue hpue--success">'. esc_html__('Datos actualizados correctamente.', 'hp-editar-usuario') .'</div>';
        }
        return ob_get_clean();
    }

    public function handle_submit() {
        if ( empty($_POST['hpue_action']) || $_POST['hpue_action'] !== 'update_user' ) return;
        if ( ! isset($_POST['hpue_nonce']) || ! wp_verify_nonce( $_POST['hpue_nonce'], 'hpue_update_user' ) ) return;
        if ( ! is_user_logged_in() ) return;

        $user = wp_get_current_user();
        $uid = $user->ID;

        $userdata = ['ID' => $uid];
        if ( isset($_POST['first_name']) ) $userdata['first_name'] = sanitize_text_field($_POST['first_name']);
        if ( isset($_POST['last_name']) )  $userdata['last_name']  = sanitize_text_field($_POST['last_name']);
        if ( isset($_POST['user_email']) && is_email($_POST['user_email']) ) $userdata['user_email'] = sanitize_email($_POST['user_email']);
        if ( isset($_POST['user_url']) )   $userdata['user_url']   = esc_url_raw($_POST['user_url']);
        if ( isset($_POST['meta']['about-me']) ) { $userdata['description'] = wp_kses_post($_POST['meta']['about-me']); }
        wp_update_user( $userdata );

        $meta = isset($_POST['meta']) ? (array) $_POST['meta'] : [];
        $save_meta = [
            'country' => 'sanitize_text_field',
            'languages' => 'sanitize_text_field',
            'phone' => 'sanitize_text_field',
            'email' => 'sanitize_email',
            'position' => 'sanitize_text_field',
            'about-me' => function($v){ return wp_kses_post($v); },
            'link_de_facebook' => 'esc_url_raw',
            'link_de_whatsapp' => 'esc_url_raw',
            'link_de_instagram' => 'esc_url_raw',
        ];
        foreach ( $save_meta as $k => $cb ) {
            if ( isset($meta[$k]) ) {
                $val = is_callable($cb) ? call_user_func($cb, $meta[$k]) : sanitize_text_field($meta[$k]);
                update_user_meta( $uid, $k, $val );
            }
        }

        if ( ! empty($_FILES['profile_picture_file']['name']) ) {
            require_once ABSPATH . 'wp-admin/includes/file.php';
            require_once ABSPATH . 'wp-admin/includes/image.php';
            require_once ABSPATH . 'wp-admin/includes/media.php';
            $attach_id = media_handle_upload( 'profile_picture_file', 0 );
            if ( ! is_wp_error($attach_id) ) {
                update_user_meta( $uid, 'profile-picture', (int) $attach_id );
            }
        }

        if ( ! empty($_FILES['photo_file']['name']) ) {
            require_once ABSPATH . 'wp-admin/includes/file.php';
            require_once ABSPATH . 'wp-admin/includes/image.php';
            require_once ABSPATH . 'wp-admin/includes/media.php';
            $attach_id = media_handle_upload( 'photo_file', 0 );
            if ( ! is_wp_error($attach_id) ) {
                update_user_meta( $uid, 'photo', (int) $attach_id );
            }
        }

        $billing = isset($_POST['billing']) ? (array) $_POST['billing'] : [];
        $shipping = isset($_POST['shipping']) ? (array) $_POST['shipping'] : [];
        foreach ( $billing as $k => $v ) {
            $val = in_array($k, ['billing_email']) ? sanitize_email($v) : sanitize_text_field($v);
            update_user_meta( $uid, $k, $val );
        }
        foreach ( $shipping as $k => $v ) {
            update_user_meta( $uid, $k, sanitize_text_field($v) );
        }

        if ( ! empty($meta['phone']) ) {
            update_user_meta( $uid, 'billing_phone', sanitize_text_field($meta['phone']) );
        } elseif ( ! empty($billing['billing_phone']) ) {
            update_user_meta( $uid, 'phone', sanitize_text_field($billing['billing_phone']) );
        }
        if ( ! empty($meta['email']) && is_email($meta['email']) ) {
            update_user_meta( $uid, 'billing_email', sanitize_email($meta['email']) );
        } elseif ( ! empty($billing['billing_email']) ) {
            update_user_meta( $uid, 'email', sanitize_email($billing['billing_email']) );
        }
        if ( ! empty($meta['country']) ) {
            update_user_meta( $uid, 'billing_country', sanitize_text_field($meta['country']) );
        } elseif ( ! empty($billing['billing_country']) ) {
            update_user_meta( $uid, 'country', sanitize_text_field($billing['billing_country']) );
        }

        // Get current page URL without query parameters
        $redirect_url = remove_query_arg( array('hpue_saved'), wp_get_referer() ? wp_get_referer() : $_SERVER['REQUEST_URI'] );
        $redirect_url = add_query_arg( 'hpue_saved', '1', $redirect_url );
        
        wp_safe_redirect( $redirect_url );
        exit;
    }
}
