# 🚀 INSTRUCCIONES PARA STAGING - Vista Previa Editable

## 📋 Versión Actualizada: 1.2.0

### 🔄 Pasos para Actualizar en Staging

1. **Subir archivos actualizados** al servidor staging
2. **Desactivar y reactivar** el plugin para forzar recarga
3. **Limpiar caché** del navegador (Ctrl+F5)

---

## 🎯 CÓMO PROBAR LA NUEVA FUNCIONALIDAD

### ✅ Paso 1: Verificar Botones
Deberías ver **DOS botones diferentes**:
- **"📋 Vista Previa EDITABLE"** (azul, principal)
- **"👀 Vista Previa Simple"** (gris, secundario)

### ✅ Paso 2: Probar Vista Previa EDITABLE
1. Ingresa ID: `6245` (el que ya probaste)
2. Haz clic en **"📋 Vista Previa EDITABLE"**
3. **Debe aparecer una alerta** que diga: "🚀 Iniciando Vista Previa EDITABLE para propiedad: 6245"
4. **Luego debe aparecer el formulario editable** completo

### ✅ Paso 3: Verificar Formulario Editable
El formulario debe tener:
- **Secciones organizadas** (Información Básica, Autor, Características, Ubicación)
- **Todos los campos prellenados** con datos de BDweb
- **Badges de estado** (✅ Usuario encontrado, etc.)
- **Botón "🚀 Importar con estos datos"**

---

## 🔍 SI NO FUNCIONA

### Debug Paso a Paso:

#### 1. **¿Ves los dos botones diferentes?**
- ❌ **No**: El caché no se actualizó
  - Solución: Ctrl+F5 o limpiar caché del navegador
  - Verificar que subiste todos los archivos

#### 2. **¿Aparece la alerta al hacer clic?**
- ❌ **No**: Hay un error de JavaScript
  - Solución: Abrir F12 → Console y buscar errores
  - Verificar que el archivo `admin.js` se cargó correctamente

#### 3. **¿La alerta aparece pero no el formulario?**
- ❌ **Probable**: Error en la petición AJAX
  - Solución: Ver F12 → Network tab
  - Buscar la petición `hp_bdweb_get_editable_property`
  - Verificar respuesta del servidor

#### 4. **¿Hay errores en Console?**
- Buscar mensajes como:
  - `🔍 Obteniendo datos editables para propiedad:`
  - `📋 Respuesta recibida:`
  - `🎨 Renderizando formulario editable...`

---

## 🎯 URLs de Debug

### Verificar que los archivos se cargaron:
- `tu-staging.com/wp-content/plugins/hunter-price-importar-bdweb/assets/js/admin.js?ver=1.2.0`
- `tu-staging.com/wp-content/plugins/hunter-price-importar-bdweb/assets/css/admin.css?ver=1.2.0`

### En la consola del navegador debería aparecer:
```
🚀 Sistema de importación BDweb con vista previa editable iniciado ✅
```

---

## 🚨 SOLUCIÓN RÁPIDA

Si nada funciona, prueba esto:

1. **Desactivar plugin** en WordPress Admin
2. **Borrar caché** del navegador completamente
3. **Reactivar plugin** 
4. **Ir a la página** con Ctrl+F5

---

## 📞 Información para Debug

Si sigues teniendo problemas, revisa:

1. **Errores de PHP**: Logs del servidor
2. **Errores de JavaScript**: F12 → Console
3. **Peticiones AJAX**: F12 → Network
4. **Versión cargada**: Revisar que sea 1.2.0 en el código fuente

La funcionalidad está **100% implementada**, solo necesita que se carguen correctamente los archivos actualizados.