/**
 * MÉTODO ALTERNATIVO SIN ES6 MODULES
 * Si los modules siguen fallando, usar este método
 */

// Cambiar el import en admin.js por esto:
/*
// OPCIÓN ALTERNATIVA: Cargar funciones desde window global
window.HPBDWEB_AJAX = window.HPBDWEB_AJAX || {};

// Función base AJAX
window.HPBDWEB_AJAX.makeRequest = async function(action, extraData = {}) {
    const { ajax_url, nonce } = window.HPBDWEB_SETTINGS || {};
    if (!ajax_url || !nonce) throw new Error('Config no disponible.');

    const form = new FormData();
    form.append('action', action);
    form.append('_wpnonce', nonce);
    
    Object.keys(extraData).forEach(key => {
        form.append(key, extraData[key]);
    });

    const res = await fetch(ajax_url, {
        method: 'POST',
        credentials: 'same-origin',
        body: form
    });

    const text = await res.text();
    let data;
    try { 
        data = JSON.parse(text); 
    } catch (e) { 
        throw new Error(`JSON Parse Error: ${e.message}`); 
    }

    if (!res.ok || !data || !data.success) {
        let errorMsg = data?.data?.message || data?.message || 'Error desconocido';
        throw new Error(errorMsg);
    }
    
    return data;
};

// Funciones específicas
window.HPBDWEB_AJAX.getEditableProperty = function(propertyId) {
    return window.HPBDWEB_AJAX.makeRequest('hp_bdweb_get_editable_property', {
        property_id: propertyId
    });
};

window.HPBDWEB_AJAX.importEditedProperty = function(editedData) {
    return window.HPBDWEB_AJAX.makeRequest('hp_bdweb_import_edited_property', {
        edited_data: editedData
    });
};

// Y así sucesivamente para todas las funciones...
*/

// Y en admin.js cambiar:
// const resp = await getEditableProperty(propertyId);
// Por:
// const resp = await window.HPBDWEB_AJAX.getEditableProperty(propertyId);