<?php
/**
 * Plugin Name:       Hunter Price – Importar de BDweb original
 * Plugin URI:        https://bdwebmx.com/
 * Description:       Plugin modular para importar datos desde BDweb. Incluye página de Admin con botón de prueba AJAX.
 * Version:           1.3.1
 * Author:            Hunter Price Mx
 * Author URI:        mailto:hunterpricemx@gmail.com
 * Text Domain:       hp-bdweb-import
 * Requires at least: 6.2
 * Requires PHP:      7.4
 */

if ( ! defined( 'ABSPATH' ) ) { exit; }

// -----------------------------------------------------------------------------
// Constants
// -----------------------------------------------------------------------------
define( 'HPBDWEB_VER',     '1.3.1' );
define( 'HPBDWEB_SLUG',    'hp-bdweb-import' );
define( 'HPBDWEB_CAP',     'manage_options' );
define( 'HPBDWEB_NONCE',   'hp_bdweb_nonce' );
define( 'HPBDWEB_FILE',    __FILE__ );
define( 'HPBDWEB_DIR',     plugin_dir_path( __FILE__ ) );
define( 'HPBDWEB_URL',     plugin_dir_url( __FILE__ ) );

// -----------------------------------------------------------------------------
// Includes (modular)
// -----------------------------------------------------------------------------
require_once HPBDWEB_DIR . 'includes/class-plugin.php';
require_once HPBDWEB_DIR . 'includes/Admin/class-admin-page.php';
require_once HPBDWEB_DIR . 'includes/Admin/class-ajax.php';

// -----------------------------------------------------------------------------
// Bootstrap
// -----------------------------------------------------------------------------
add_action( 'plugins_loaded', function() {
    \HPBDWEB\Plugin::instance();
});
