<?php
namespace HPBDWEB\Admin;

if ( ! defined( 'ABSPATH' ) ) { exit; }

final class Admin_Page {

    public static function render() {
        if ( ! current_user_can( HPBDWEB_CAP ) ) {
            wp_die( esc_html__( 'No tienes permisos para acceder a esta página.', 'hp-bdweb-import' ) );
        }
        ?>
        <div class="wrap hpbdweb-admin">
            <h1 class="hpbdweb-admin__title"><?php echo esc_html__( 'Hunter Price – Importar de BDweb', 'hp-bdweb-import' ); ?></h1>
            <p class="hpbdweb-admin__intro">
                <?php echo esc_html__( 'Conecta e importa propiedades desde BDweb usando la REST API.', 'hp-bdweb-import' ); ?>
            </p>

            <!-- Configuración Google Maps -->
            <section class="hpbdweb-admin__section">
                <h2 class="hpbdweb-admin__section-title">🗺️ Configuración Google Maps</h2>
                <div class="hpbdweb-admin__maps-config">
                    
                    <!-- Estado de configuración -->
                    <div class="hpbdweb-admin__status-success" style="background: #d1eddb; border: 1px solid #00a32a; border-radius: 4px; padding: 15px; margin-bottom: 20px;">
                        <h4 style="color: #00a32a; margin: 0 0 10px 0;">✅ Configuración Detectada</h4>
                        <p><strong>🔗 Plugin Crear Propiedad:</strong> Disponible</p>
                        <p><small>El sistema usará automáticamente la API Key configurada en Crear Propiedad.</small></p>
                        
                        <div style="margin-top: 15px; padding: 10px; background: rgba(255,255,255,0.8); border-radius: 3px;">
                            <p><strong>🚀 Funcionalidades Activas:</strong></p>
                            <ul style="margin: 8px 0 0 20px; color: #135e96;">
                                <li>✅ Geocoding automático de direcciones</li>
                                <li>✅ Obtención de coordenadas GPS</li>
                                <li>✅ Enlaces directos a Google Maps</li>
                                <li>✅ Hasta 40,000 solicitudes gratis/mes</li>
                            </ul>
                        </div>
                    </div>

                    <!-- Formulario opcional -->
                    <details style="margin-top: 15px; border: 1px solid #ddd; border-radius: 4px;">
                        <summary style="padding: 10px 15px; background: #f6f7f7; cursor: pointer; font-weight: 600;">⚙️ Configurar API Key Propia (Opcional)</summary>
                        
                        <div style="padding: 15px;">
                            <form method="post" action="">
                                <?php wp_nonce_field( 'hpbdweb_save_config', 'hpbdweb_config_nonce' ); ?>
                                <div class="hpbdweb-admin__field">
                                    <label class="hpbdweb-admin__label" for="google-maps-api-key">
                                        Google Maps API Key:
                                    </label>
                                    <input 
                                        type="password" 
                                        id="google-maps-api-key" 
                                        name="hpbdweb_google_maps_api_key"
                                        class="hpbdweb-admin__input" 
                                        value="<?php echo esc_attr( get_option( 'hpbdweb_google_maps_api_key', '' ) ); ?>"
                                        placeholder="AIzaSyC... (opcional)"
                                    />
                                    <button type="submit" class="button button-primary">
                                        💾 Guardar
                                    </button>
                                </div>
                            </form>
                            
                            <div class="hpbdweb-admin__help">
                                <p><strong>📍 Geocoding Automático:</strong> Si una propiedad no tiene coordenadas GPS, se obtendrán automáticamente.</p>
                                <p><strong>🔑 Obtener API Key:</strong> <a href="https://console.cloud.google.com/apis/credentials" target="_blank">Google Cloud Console</a></p>
                                <p><strong>💰 Costo:</strong> Gratuito hasta 40,000 solicitudes/mes</p>
                            </div>
                        </div>
                    </details>

                    <?php
                    // Manejar guardado simple
                    if ( isset( $_POST['hpbdweb_config_nonce'] ) && wp_verify_nonce( $_POST['hpbdweb_config_nonce'], 'hpbdweb_save_config' ) ) {
                        if ( isset( $_POST['hpbdweb_google_maps_api_key'] ) ) {
                            update_option( 'hpbdweb_google_maps_api_key', sanitize_text_field( $_POST['hpbdweb_google_maps_api_key'] ) );
                            echo '<div class="notice notice-success"><p>✅ Configuración guardada correctamente.</p></div>';
                        }
                    }
                    ?>
                </div>
            </section>

            <!-- Configuración Anti-Timeout -->
            <section class="hpbdweb-admin__section">
                <h2 class="hpbdweb-admin__section-title"><?php echo esc_html__( '⚙️ Configuración del Servidor', 'hp-bdweb-import' ); ?></h2>
                <div class="hpbdweb-admin__server-info">
                    <div class="hpbdweb-admin__server-limits">
                        <h4><?php echo esc_html__( 'Límites Actuales', 'hp-bdweb-import' ); ?></h4>
                        <ul>
                            <li><strong>Memoria PHP:</strong> <?php echo ini_get('memory_limit'); ?></li>
                            <li><strong>Tiempo máximo:</strong> <?php echo ini_get('max_execution_time'); ?>s</li>
                            <li><strong>Upload máximo:</strong> <?php echo ini_get('upload_max_filesize'); ?></li>
                        </ul>
                    </div>
                    <div class="hpbdweb-admin__optimizations">
                        <h4><?php echo esc_html__( '🚀 Optimizaciones Activas', 'hp-bdweb-import' ); ?></h4>
                        <ul>
                            <li>✅ <strong>Heartbeat:</strong> Mantiene conexión viva</li>
                            <li>✅ <strong>Límite imágenes:</strong> 3 por propiedad</li>
                            <li>✅ <strong>Timeout imágenes:</strong> 10 segundos</li>
                            <li>✅ <strong>Gestión memoria:</strong> Limpieza automática</li>
                            <li>✅ <strong>Batch processing:</strong> Evita sobrecargas</li>
                            <li>✅ <strong>Geocoding GPS:</strong> Coordenadas automáticas</li>
                        </ul>
                    </div>
                </div>
            </section>

            <!-- API Connection Test -->
            <section class="hpbdweb-admin__section">
                <h2 class="hpbdweb-admin__section-title"><?php echo esc_html__( 'Conexión API', 'hp-bdweb-import' ); ?></h2>
                <div class="hpbdweb-admin__controls">
                    <button id="hpbdweb-test-api-btn" class="button button-primary hpbdweb-admin__btn">
                        <?php echo esc_html__( 'Probar API BDweb', 'hp-bdweb-import' ); ?>
                    </button>
                    <button id="hpbdweb-load-properties-btn" class="button button-secondary hpbdweb-admin__btn">
                        <?php echo esc_html__( 'Cargar Propiedades (Paginado)', 'hp-bdweb-import' ); ?>
                    </button>
                    <button id="hpbdweb-batch-import-btn" class="button button-primary hpbdweb-admin__btn">
                        <?php echo esc_html__( '🔄 Importación por Lotes', 'hp-bdweb-import' ); ?>
                    </button>
                </div>
                <div class="hpbdweb-admin__api-status" id="hpbdweb-api-status">
                    <?php echo esc_html__( 'API no probada', 'hp-bdweb-import' ); ?>
                </div>
            </section>

            <!-- Property Importer -->
            <section class="hpbdweb-admin__section">
                <h2 class="hpbdweb-admin__section-title">🏡 <?php echo esc_html__( 'Importar Propiedad Individual', 'hp-bdweb-import' ); ?></h2>
                <div class="hpbdweb-admin__single-import">
                    <div class="hpbdweb-admin__field">
                        <label class="hpbdweb-admin__label" for="property-id-input">
                            <?php echo esc_html__( 'ID de Propiedad:', 'hp-bdweb-import' ); ?>
                        </label>
                        <input type="number" id="property-id-input" class="hpbdweb-admin__input" placeholder="6269" min="1" />
                        <button id="hpbdweb-preview-btn" class="button button-primary hpbdweb-admin__btn" style="background: #0073aa; border-color: #0073aa;">
                            📋 <?php echo esc_html__( 'Vista Previa EDITABLE', 'hp-bdweb-import' ); ?>
                        </button>
                        <button id="hpbdweb-old-preview-btn" class="button button-secondary hpbdweb-admin__btn">
                            👀 <?php echo esc_html__( 'Vista Previa Simple', 'hp-bdweb-import' ); ?>
                        </button>
                        <button id="hpbdweb-debug-btn" class="button button-secondary hpbdweb-admin__btn">
                            <?php echo esc_html__( '🔍 Debug', 'hp-bdweb-import' ); ?>
                        </button>
                    </div>
                    
                    <div id="hpbdweb-property-preview" class="hpbdweb-admin__preview" style="display: none;">
                        <!-- Editable property preview will be loaded here -->
                    </div>
                </div>
            </section>

            <!-- Properties List -->
            <section class="hpbdweb-admin__section">
                <h2 class="hpbdweb-admin__section-title"><?php echo esc_html__( 'Lista de Propiedades', 'hp-bdweb-import' ); ?></h2>
                
                <div class="hpbdweb-admin__pagination-controls" id="hpbdweb-pagination-controls" style="display: none;">
                    <div class="hpbdweb-admin__pagination-info">
                        <span id="hpbdweb-pagination-info"><?php echo esc_html__( 'Página 1 de 1', 'hp-bdweb-import' ); ?></span>
                        <span id="hpbdweb-page-status" class="hpbdweb-admin__page-status"></span>
                    </div>
                    <div class="hpbdweb-admin__pagination-buttons">
                        <button id="hpbdweb-prev-page-btn" class="button hpbdweb-admin__btn" disabled>
                            <?php echo esc_html__( '← Anterior', 'hp-bdweb-import' ); ?>
                        </button>
                        <button id="hpbdweb-next-page-btn" class="button hpbdweb-admin__btn" disabled>
                            <?php echo esc_html__( 'Siguiente →', 'hp-bdweb-import' ); ?>
                        </button>
                        <button id="hpbdweb-import-page-btn" class="button button-primary hpbdweb-admin__btn">
                            <?php echo esc_html__( '📦 Importar Esta Página', 'hp-bdweb-import' ); ?>
                        </button>
                    </div>
                </div>

                <div id="hpbdweb-properties-list" class="hpbdweb-admin__properties-list">
                    <?php echo esc_html__( 'Haz clic en "Cargar Propiedades" para ver la lista', 'hp-bdweb-import' ); ?>
                </div>
            </section>

            <!-- Output Log -->
            <section class="hpbdweb-admin__section">
                <h2 class="hpbdweb-admin__section-title"><?php echo esc_html__( 'Log de Actividad', 'hp-bdweb-import' ); ?></h2>
                <div class="hpbdweb-admin__controls">
                    <button id="hpbdweb-clear-log-btn" class="button button-link-delete hpbdweb-admin__btn--small">
                        <?php echo esc_html__( 'Limpiar Log', 'hp-bdweb-import' ); ?>
                    </button>
                </div>
                <pre id="hpbdweb-output" class="hpbdweb-admin__output"><?php echo esc_html__( 'Sin actividad aún...', 'hp-bdweb-import' ); ?></pre>
            </section>
        </div>
        <?php
    }
}
