<?php
namespace Jet_Theme_Core\Template_Conditions;

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

class CPT_Archive_Taxonomy extends Base {

	/**
	 * Condition slug
	 *
	 * @return string
	 */
	public function get_id() {
		return 'archive-tax';
	}

	/**
	 * Condition label
	 *
	 * @return string
	 */
	public function get_label() {
		return __( 'CPT Taxonomy(legacy)', 'jet-theme-core' );
	}

	/**
	 * Condition group
	 *
	 * @return string
	 */
	public function get_group() {
		return 'archive';
	}

	/**
	 * @return int
	 */
	public  function get_priority() {
		return 8;
	}

	/**
	 * @return string
	 */
	public function get_body_structure() {
		return 'jet_archive';
	}

	/**
	 * @return array
	 */
	public function get_node_data() {
		return [
			'node'   => $this->get_id(),
			'parent' => 'archive-all',
			'label' => __( 'CPT Taxonomy(legacy)', 'jet-theme-core' ),
			'subNode' => true,
			'nodeInfo'  => [
				'title'     => __( 'CPT Taxonomy(legacy)', 'jet-theme-core' ),
				'desc'      => __( 'Templates for CPT archives(legacy)', 'jet-theme-core' ),
			]
		];
	}

	/**
	 * [get_control description]
	 * @return [type] [description]
	 */
	public function get_control() {
		return [
			'type'        => 'f-select',
			'placeholder' => __( 'Select Taxonomy', 'jet-theme-core' ),
		];
	}

	/**
	 * [get_avaliable_options description]
	 * @return [type] [description]
	 */
	public function get_avaliable_options() {
		return \Jet_Theme_Core\Utils::get_taxonomies();
	}

	/**
	 * [get_label_by_value description]
	 * @param  string $value [description]
	 * @return [type]        [description]
	 */
	public function get_label_by_value( $value = '' ) {

		if ( empty( $value ) ) {
			return '';
		}

		$value = ! is_array( $value ) ? explode(' ', $value ) : $value;

		$result = [];

		foreach ( $value as $taxonomy ) {
			$obj = get_taxonomy( $taxonomy );

			$result[] = $obj->label;
		}

		return implode( ', ', $result );
	}

	/**
	 * Condition check callback
	 *
	 * @return bool
	 */
	public function check( $arg = '' ) {
		$queried_object = get_queried_object();

		if ( ! is_array( $arg ) ) {
			$arg = explode( ',', $arg );
		}

		if ( is_a( $queried_object, 'WP_Term' ) ) {
			$taxonomy = $queried_object->taxonomy;

			if ( in_array( $taxonomy, $arg ) ) {
				return true;
			}
		}

		return false;
	}

}
