<?php
/**
 * View: Group icon.
 *
 * @since 4.22.0
 * @version 4.22.0
 *
 * @var string[] $classes        Additional classes to add to the svg icon.
 * @var string   $label          The label for the icon.
 * @var bool     $is_aria_hidden Whether the icon is hidden from screen readers. Default false to show the icon.
 * @var Template $this           The template instance.
 *
 * @package LearnDash\Core
 */

use LearnDash\Core\Template\Template;

$svg_classes = [ 'ld-svgicon__group' ];

if ( ! empty( $classes ) ) {
	$svg_classes = array_merge( $svg_classes, $classes );
}

if ( empty( $label ) ) {
	$label = sprintf(
		// translators: %s: Group label.
		__( '%s icon', 'learndash' ),
		learndash_get_custom_label( 'group' )
	);
}

$this->template(
	'components/icons/icon/start',
	[
		'classes' => $svg_classes,
		'height'  => 24,
		'label'   => $label,
		'width'   => 24,
	],
);
?>

<path fill-rule="evenodd" clip-rule="evenodd" d="M10 6.46875C8.69254 6.46875 7.675 7.49296 7.675 8.70486C7.675 9.91676 8.69254 10.941 10 10.941C11.3075 10.941 12.325 9.91676 12.325 8.70486C12.325 7.49296 11.3075 6.46875 10 6.46875ZM5.925 8.70486C5.925 6.48032 7.77284 4.71875 10 4.71875C12.2272 4.71875 14.075 6.48032 14.075 8.70486C14.075 10.9294 12.2272 12.691 10 12.691C7.77284 12.691 5.925 10.9294 5.925 8.70486ZM13.9858 5.49946C14.1628 5.04978 14.6708 4.82871 15.1204 5.00568C16.6051 5.58997 17.675 7.01591 17.675 8.70486C17.675 10.3938 16.6051 11.8198 15.1204 12.404C14.6708 12.581 14.1628 12.3599 13.9858 11.9103C13.8088 11.4606 14.0299 10.9526 14.4796 10.7756C15.3404 10.4369 15.925 9.6272 15.925 8.70486C15.925 7.78252 15.3404 6.97287 14.4796 6.63411C14.0299 6.45714 13.8088 5.94914 13.9858 5.49946ZM8.76998 14.0521H11.23C11.9501 14.0521 12.5335 14.0521 13.0088 14.0836C13.4982 14.1161 13.9354 14.1847 14.3514 14.3522C15.3459 14.7527 16.1437 15.5241 16.5614 16.5047C16.7372 16.9173 16.8087 17.3503 16.8424 17.8302C16.875 18.2949 16.875 18.8642 16.875 19.5623V19.5938C16.875 20.077 16.4832 20.4688 16 20.4688C15.5168 20.4688 15.125 20.077 15.125 19.5938C15.125 18.8566 15.1245 18.3489 15.0967 17.9527C15.0695 17.565 15.0192 17.3497 14.9514 17.1906C14.7196 16.6465 14.2715 16.2066 13.6977 15.9756C13.5257 15.9063 13.2962 15.8565 12.893 15.8298C12.4824 15.8025 11.9571 15.8021 11.2 15.8021H8.8C8.04285 15.8021 7.5176 15.8025 7.10702 15.8298C6.70383 15.8565 6.47429 15.9063 6.30227 15.9756C5.72854 16.2066 5.28039 16.6465 5.04857 17.1906C4.98078 17.3497 4.93052 17.565 4.9033 17.9527C4.8755 18.3489 4.875 18.8566 4.875 19.5938C4.875 20.077 4.48325 20.4688 4 20.4688C3.51675 20.4688 3.125 20.077 3.125 19.5938L3.125 19.5623C3.12499 18.8642 3.12499 18.2949 3.1576 17.8302C3.19128 17.3503 3.26281 16.9173 3.4386 16.5047C3.85635 15.5241 4.65411 14.7527 5.64855 14.3522C6.06461 14.1847 6.50185 14.1161 6.99119 14.0836C7.46654 14.0521 8.04994 14.0521 8.76998 14.0521ZM16.7512 14.8127C16.8685 14.3439 17.3436 14.059 17.8124 14.1763C19.5574 14.6129 20.875 16.1623 20.875 18.0382V19.5938C20.875 20.077 20.4832 20.4688 20 20.4688C19.5168 20.4688 19.125 20.077 19.125 19.5938V18.0382C19.125 17.0148 18.4029 16.128 17.3876 15.8739C16.9188 15.7566 16.6339 15.2815 16.7512 14.8127Z" fill="currentColor"/>

<?php
$this->template( 'components/icons/icon/end' );
