
<?php
add_action('wp_ajax_tba_import_property', 'tba_import_property_callback');

function tba_import_property_callback() {
    check_ajax_referer('tba_nonce', 'nonce');

    $api_key = sanitize_text_field($_POST['api_key'] ?? '');
    $id      = intval($_POST['id'] ?? 0);

    error_log('TBI DEBUG: AJAX llamado con ID: ' . $id . ', API Key: ' . substr($api_key, 0, 10) . '...');

    if (!$api_key || !$id) {
        error_log('TBI ERROR: Datos incompletos en AJAX');
        wp_send_json_error(['message' => 'Datos incompletos.']);
    }

    $url = add_query_arg(['key' => $api_key], "https://tokkobroker.com/api/v1/property/{$id}/");
    error_log('TBI DEBUG: URL de API: ' . $url);
    
    $resp = wp_remote_get($url);

    if (is_wp_error($resp)) {
        error_log('TBI ERROR: Error WP: ' . $resp->get_error_message());
        wp_send_json_error(['message' => 'Error de conexión: ' . $resp->get_error_message()]);
    }
    
    $response_code = wp_remote_retrieve_response_code($resp);
    if ($response_code !== 200) {
        error_log('TBI ERROR: Código de respuesta: ' . $response_code);
        wp_send_json_error(['message' => 'No se pudo obtener la propiedad. Código: ' . $response_code]);
    }

    $body = wp_remote_retrieve_body($resp);
    $obj = json_decode($body, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        error_log('TBI ERROR: Error JSON: ' . json_last_error_msg());
        wp_send_json_error(['message' => 'Error al procesar JSON: ' . json_last_error_msg()]);
    }

    error_log('TBI DEBUG: Datos recibidos de API: ' . print_r($obj, true));

    if (tbi_importar_una_propiedad_desde_tokko($obj)) {
        wp_send_json_success(['message' => 'Propiedad importada correctamente.']);
    } else {
        wp_send_json_error(['message' => 'No se pudo importar. Ya existe o hubo error.']);
    }
}
