
jQuery(document).ready(function($) {
    // Debug para verificar que se carga correctamente
    console.log('🔄 TBA Importer JS cargado - Timestamp:', new Date().toISOString());
    console.log('🔄 TBA Ajax Config:', TBA_Ajax);
    
    $('#tba-fetch-btn').on('click', function() {
        const apiKey = $('#tba-api-key').val();
        const url = `https://tokkobroker.com/api/v1/property/?key=${apiKey}&limit=10`;

        $('#tba-properties-container').html('<p>Cargando propiedades...</p>');

        $.getJSON(url, function(response) {
            if (response.objects && response.objects.length > 0) {
                let html = '<table class="tba-importer__table"><thead><tr><th>Preview</th><th>ID</th><th>Título</th><th>Precio</th><th>Acción</th></tr></thead><tbody>';
                response.objects.forEach(obj => {
                    const id = obj.id;
                    const title = obj.publication_title;
                    const price = obj.operations[0]?.prices[0]?.price ?? 'N/A';
                    const thumb = obj.photos[0]?.thumb ?? '';

                    
                    html += `<tr class="tba-importer__row">
                        <td data-id="${id}" data-title="${title}" data-price="${price}" data-address="${obj.location.full_location}" data-city="${obj.location.city}" data-state="${obj.location.state}" data-operation="${obj.operations[0].operation_type}" data-property-type="${obj.type.name}">
                            ${thumb ? `<img src="${thumb}" width="80">` : ''}
                        </td>
                        <td data-id="${id}" data-title="${title}" data-price="${price}">${id}</td>
                        <td data-id="${id}" data-title="${title}" data-price="${price}">${title}</td>
                        <td data-id="${id}" data-title="${title}" data-price="${price}">${price}</td>
                        <td><button class="tba-importer__button tba-importer__button--import" data-id="${id}" data-nonce="${TBA_Ajax.nonce}">Importar</button></td>
                    </tr>`;
                });
                html += '</tbody></table>';
                $('#tba-properties-container').html(html);
            } else {
                $('#tba-properties-container').html('<p>No se encontraron propiedades.</p>');
            }
        }).fail(function() {
            $('#tba-properties-container').html('<p>Error al consultar la API de Tokko.</p>');
        });
    });

    $(document).on('click', '.tba-importer__button--import', function() {
        const $btn = $(this);
        const id = $btn.data('id');
        const apiKey = $('#tba-api-key').val(); // Obtener la API key del input

        console.log("🔘 Importar clic:", id, apiKey);

        $btn.text('Importando...').prop('disabled', true);

        try {
            $.post(TBA_Ajax.ajax_url, {
                action: 'tba_import_property',
                nonce: TBA_Ajax.nonce,
                id: id,
                api_key: apiKey,
                _t: TBA_Ajax.timestamp // Timestamp para evitar cache
            })
            .done(function(response) {
                console.log("✅ AJAX éxito:", response);
                if (response.success) {
                    $btn.text('Importado ✅').addClass('tba-importer__button--success');
                } else {
                    $btn.text('Error ❌').prop('disabled', false);
                }
            })
            .fail(function(xhr) {
                console.error("❌ AJAX error:", xhr.responseText);
                $btn.text('Error ❌').prop('disabled', false);
            });
        } catch (err) {
            console.error("🧨 Excepción:", err);
            $btn.text('Error ❌').prop('disabled', false);
        }
    });
});
