<?php
/**
 * Plugin Name: Tokko Broker AJAX Importer
 * Description: Paso 1 - Formulario con API key por defecto.
 * Version: 0.1
 * Author: Alrit
 */

if (!defined('ABSPATH')) exit;

// Definir constantes del plugin
define('TBA_VERSION', '1.0.1');
define('TBA_TIMESTAMP', time());

// Shortcode: [importar_tokko_ajax]
function tba_shortcode_formulario_api_key() {
    $default_key = 'cd41a683f90de60cd712bb8aa03767a49c089059';
    ob_start(); ?>
    <div class="tba-importer">
        <div class="tba-debug-info" style="font-size: 11px; color: #666; margin-bottom: 10px;">
            Plugin v<?php echo TBA_VERSION; ?> - Cargado: <?php echo date('H:i:s'); ?>
            <button type="button" onclick="location.reload(true)" style="margin-left: 10px; font-size: 10px;">🔄 Recargar</button>
        </div>
        <label class="tba-importer__label">API Key:
            <input type="text" id="tba-api-key" class="tba-importer__input" value="<?php echo esc_attr($default_key); ?>" required>
        </label>
        <button id="tba-fetch-btn" class="tba-importer__button tba-importer__button--primary">Consultar propiedades</button>
        <div id="tba-properties-container"></div>
    </div>
    <?php
    return ob_get_clean();
}
add_shortcode('importar_tokko_ajax', 'tba_shortcode_formulario_api_key');


// Registrar y cargar script JS con versión generada dinámicamente en tiempo real
function tba_enqueue_scripts() {
    // Generar versión única basada en timestamp + hash del archivo para evitar cache
    $js_file = plugin_dir_path(__FILE__) . 'js/importer.js';
    $js_version = filemtime($js_file) . '_' . substr(md5_file($js_file), 0, 8);
    
    wp_enqueue_script('tba-importer-js', plugin_dir_url(__FILE__) . 'js/importer.js', ['jquery'], $js_version, true);
    
    // Log para debug del cache
    error_log('TBA DEBUG: JS cargado con versión: ' . $js_version);
}
add_action('wp_enqueue_scripts', 'tba_enqueue_scripts');

// Registrar estilos CSS con versión anti-cache también
function tba_enqueue_styles() {
    // Generar versión única para CSS también
    $css_file = plugin_dir_path(__FILE__) . 'css/importer.css';
    $css_version = filemtime($css_file) . '_' . substr(md5_file($css_file), 0, 8);
    
    wp_enqueue_style('tba-importer-css', plugin_dir_url(__FILE__) . 'css/importer.css', [], $css_version);
    
    error_log('TBA DEBUG: CSS cargado con versión: ' . $css_version);
}
add_action('wp_enqueue_scripts', 'tba_enqueue_styles');

// Incluir archivos necesarios
require_once plugin_dir_path(__FILE__) . 'includes/import-functions.php';
require_once plugin_dir_path(__FILE__) . 'includes/ajax-handler.php';
// Pasar AJAX nonce y URL con timestamp anti-cache
function tba_pass_nonce_to_script() {
    wp_localize_script('tba-importer-js', 'TBA_Ajax', [
        'ajax_url' => admin_url('admin-ajax.php'),
        'nonce'    => wp_create_nonce('tba_nonce'),
        'timestamp' => TBA_TIMESTAMP, // Para evitar cache en peticiones AJAX
        'version'  => TBA_VERSION, // Versión del plugin
    ]);
}
add_action('wp_enqueue_scripts', 'tba_pass_nonce_to_script');
