<?php
/**
 * Child functions and definitions.
 */
add_filter( 'kava-theme/assets-depends/styles', 'kava_child_styles_depends' );

/**
 * Enqueue styles.
 */
function kava_child_styles_depends( $deps ) {

	$parent_handle = 'kava-parent-theme-style';

	wp_register_style(
		$parent_handle,
		get_template_directory_uri() . '/style.css',
		array(),
		kava_theme()->version()
	);

	$deps[] = $parent_handle;

	return $deps;
}

/**
 * Disable magic button for your clients
 *
 * Un-comment next line to disble magic button output for you clients.
 */
//add_action( 'jet-theme-core/register-config', 'kava_child_disable_magic_button' );

function kava_child_disable_magic_button( $config_manager ) {
	$config_manager->register_config( array(
		'library_button' => false,
	) );
}

/**
 * Disable unnecessary theme modules
 *
 * Un-comment next line and return unnecessary modules from returning modules array.
 */
//add_filter( 'kava-theme/allowed-modules', 'kava_child_allowed_modules' );

function kava_child_allowed_modules( $modules ) {

	return array(
		'blog-layouts'    => array(),
		'crocoblock'      => array(),
		'woo'             => array(
			'woo-breadcrumbs' => array(),
			'woo-page-title'  => array(),
		),
	);

}

/**
 * Registering a new structure
 *
 * To change structure and apropriate documnet type parameters go to
 * structures/archive.php and document-types/archive.php
 *
 * To print apropriate location add next code where you need it:
 * if ( function_exists( 'jet_theme_core' ) ) {
 *     jet_theme_core()->locations->do_location( 'kava_child_archive' );
 * }
 * Where 'kava_child_archive' - apropritate location name (from example).
 *
 * Un-comment next line to register new structure.
 */
//add_action( 'jet-theme-core/structures/register', 'kava_child_structures' );

function kava_child_structures( $structures_manager ) {

	require get_theme_file_path( 'structures/archive.php' );

	$structures_manager->register_structure( 'Kava_Child_Structure_Archive' );

}



/**
 * Plugin Name: Properties Quick Edit (CPT: properties)
 * Description: Columnas y Quick Edit para metadatos del CPT "properties".
 * Version: 1.0.1
 */

if (!defined('ABSPATH')) exit;

if (!class_exists('HP_Properties_Admin_Quick_Edit')) {
class HP_Properties_Admin_Quick_Edit {
    const CPT = 'properties';

    public function __construct() {
        // Columnas
        add_filter('manage_edit-' . self::CPT . '_columns', [$this, 'add_columns']);
        add_action('manage_' . self::CPT . '_posts_custom_column', [$this, 'render_columns'], 10, 2);

        // Quick Edit UI + guardado
        add_action('quick_edit_custom_box', [$this, 'quick_edit_fields'], 10, 2);
        add_action('save_post_' . self::CPT, [$this, 'save_quick_edit']);

        // Datos ocultos por fila (para rellenar Quick Edit) — ahora en la columna "title"
        add_action('manage_' . self::CPT . '_posts_custom_column', [$this, 'output_inline_data'], 20, 2);

        // JS para rellenar Quick Edit
        add_action('admin_footer-edit.php', [$this, 'quick_edit_js']);
    }

    /** ---------------------------
     *  Columnas
     *  --------------------------*/
    public function add_columns($columns) {
        $new = [];
        foreach ($columns as $key => $label) {
            $new[$key] = $label;
            if ($key === 'title') {
                $new['hot_deals'] = 'Hot Deals';
                $new['metros_terreno'] = 'Metros Terreno';
                $new['tamano_de_construccion'] = 'Tamaño Construcción';
                $new['habitaciones'] = 'Habitaciones';
                $new['banos'] = 'Baños';
            }
        }
        return $new;
    }

    public function render_columns($column, $post_id) {
        switch ($column) {
            case 'hot_deals':
                $val = get_post_meta($post_id, '_hot-deals', true);
                echo esc_html($val === 'Yes' ? 'Yes' : ($val === 'No' ? 'No' : '—'));
                break;
            case 'metros_terreno':
                $val = get_post_meta($post_id, 'metros_terreno', true);
                echo ($val !== '') ? esc_html($val) : '—';
                break;
            case 'tamano_de_construccion':
                $val = get_post_meta($post_id, 'tamano_de_construccion', true);
                echo ($val !== '') ? esc_html($val) : '—';
                break;
            case 'habitaciones':
                $val = get_post_meta($post_id, 'habitaciones', true);
                echo ($val !== '') ? esc_html($val) : '—';
                break;
            case 'banos':
                $val = get_post_meta($post_id, 'banos', true);
                echo ($val !== '') ? esc_html($val) : '—';
                break;
        }
    }

    /** ---------------------------
     *  Quick Edit: campos (una sola vez, bajo la columna 'title')
     *  --------------------------*/
    public function quick_edit_fields($column_name, $post_type) {
    if ($post_type !== self::CPT) return;

    // Imprimir una sola vez, sin depender del nombre de columna.
    static $printed = false;
    if ($printed) return;
    $printed = true;

    wp_nonce_field('hp_properties_quick_edit', 'hp_properties_qe_nonce');
    ?>
    <fieldset class="inline-edit-col-right">
        <div class="inline-edit-col">
            <h4>Propiedades (Edición rápida)</h4>

            <label class="alignleft">
                <span class="title">Hot Deals</span>
                <span class="input-text-wrap">
                    <select name="_hot-deals" class="hp-qe-hot">
                        <option value="">—</option>
                        <option value="Yes">Yes</option>
                        <option value="No">No</option>
                    </select>
                </span>
            </label>

            <label class="alignleft">
                <span class="title">Metros Terreno</span>
                <span class="input-text-wrap">
                    <input type="number" step="1" min="0" name="metros_terreno" class="hp-qe-metros" />
                </span>
            </label>

            <label class="alignleft">
                <span class="title">Tamaño Construcción</span>
                <span class="input-text-wrap">
                    <input type="number" step="1" min="0" name="tamano_de_construccion" class="hp-qe-tamano" />
                </span>
            </label>

            <label class="alignleft">
                <span class="title">Habitaciones</span>
                <span class="input-text-wrap">
                    <select name="habitaciones" class="hp-qe-hab">
                        <option value="">—</option>
                        <?php for ($i=1; $i<=9; $i++): ?>
                            <option value="<?php echo esc_attr($i); ?>"><?php echo esc_html($i); ?></option>
                        <?php endfor; ?>
                    </select>
                </span>
            </label>

            <label class="alignleft">
                <span class="title">Baños</span>
                <span class="input-text-wrap">
                    <select name="banos" class="hp-qe-banos">
                        <option value="">—</option>
                        <?php for ($i=1; $i<=5; $i++): ?>
                            <option value="<?php echo esc_attr($i); ?>"><?php echo esc_html($i); ?></option>
                        <?php endfor; ?>
                    </select>
                </span>
            </label>
        </div>
    </fieldset>
    <?php
}


    /** ---------------------------
     *  Guardar Quick Edit
     *  --------------------------*/
    public function save_quick_edit($post_id) {
        if (!isset($_POST['hp_properties_qe_nonce']) || !wp_verify_nonce($_POST['hp_properties_qe_nonce'], 'hp_properties_quick_edit')) return;
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
        if (!current_user_can('edit_post', $post_id)) return;

        $fields = [
            '_hot-deals'              => function($v){ $v = is_string($v) ? trim($v) : ''; return in_array($v, ['Yes','No'], true) ? $v : ''; },
            'metros_terreno'          => function($v){ return ($v === '' || $v === null) ? '' : absint($v); },
            'tamano_de_construccion'  => function($v){ return ($v === '' || $v === null) ? '' : absint($v); },
            'habitaciones'            => function($v){ $v = absint($v); return ($v>=1 && $v<=9) ? $v : ''; },
            'banos'                   => function($v){ $v = absint($v); return ($v>=1 && $v<=5) ? $v : ''; },
        ];

        foreach ($fields as $key => $sanitize_cb) {
            if (array_key_exists($key, $_POST)) {
                $val = $sanitize_cb($_POST[$key]);
                if ($val === '' || $val === null) {
                    delete_post_meta($post_id, $key);
                } else {
                    update_post_meta($post_id, $key, $val);
                }
            }
        }
    }

    /** ---------------------------
     *  Datos ocultos por fila (para rellenar Quick Edit)
     *  --------------------------*/
    public function output_inline_data($column, $post_id) {
        if ($column !== 'title') return; // garantizado: siempre hay columna título

        $hot = get_post_meta($post_id, '_hot-deals', true);
        $mtt = get_post_meta($post_id, 'metros_terreno', true);
        $tac = get_post_meta($post_id, 'tamano_de_construccion', true);
        $hab = get_post_meta($post_id, 'habitaciones', true);
        $ban = get_post_meta($post_id, 'banos', true);

        printf(
            '<div class="hp-inline" id="hp_inline_%1$d"
                data-hot-deals="%2$s"
                data-metros-terreno="%3$s"
                data-tamano-construccion="%4$s"
                data-habitaciones="%5$s"
                data-banos="%6$s"
             ></div>',
            (int) $post_id,
            esc_attr($hot),
            esc_attr($mtt),
            esc_attr($tac),
            esc_attr($hab),
            esc_attr($ban)
        );
    }

    /** ---------------------------
     *  JS para completar Quick Edit
     *  --------------------------*/
    public function quick_edit_js() {
        $screen = function_exists('get_current_screen') ? get_current_screen() : null;
        if (!$screen || $screen->id !== 'edit-' . self::CPT) return;
        ?>
        <script>
        (function($){
            var $wp_inline_edit = inlineEditPost.edit;
            inlineEditPost.edit = function( id ) {
                $wp_inline_edit.apply( this, arguments );

                var postId = 0;
                if ( typeof(id) === 'object' ) postId = parseInt(this.getId(id));
                if (!postId) return;

                var $row  = $('#edit-' + postId);
                var $data = $('#hp_inline_' + postId);
                if (!$data.length) return;

                var hot  = $data.attr('data-hot-deals') || '';
                var mter = $data.attr('data-metros-terreno') || '';
                var tcon = $data.attr('data-tamano-construccion') || '';
                var hab  = $data.attr('data-habitaciones') || '';
                var ban  = $data.attr('data-banos') || '';

                $('select[name="_hot-deals"]', $row).val(hot);
                $('input[name="metros_terreno"]', $row).val(mter);
                $('input[name="tamano_de_construccion"]', $row).val(tcon);
                $('select[name="habitaciones"]', $row).val(hab);
                $('select[name="banos"]', $row).val(ban);
            };
        })(jQuery);
        </script>
        <?php
    }
}
new HP_Properties_Admin_Quick_Edit();
}

